/*
 * tools/lib/lv_write_all_lv_of_vg.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March 1997
 * August 1998
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

#include <liblvm.h>


int lv_write_all_lv_of_vg ( char *pv_name, vg_t *vg) {
   int ret = 0;
   int l = 0;
   int pvol = -1;
   uint size = 0;
   lv_disk_t *lv_this = NULL;
   lv_disk_t *lv_disk_tmp = NULL;

#ifdef DEBUG
   debug ( "lv_write_all_lv_of_vg -- CALLED  pv_name: %s\n", pv_name);
#endif

   if ( pv_name == NULL ||
        pv_check_name ( pv_name) < 0 ||
        vg == NULL ||
        vg_check_name ( vg->vg_name) < 0 ||
        vg->lv_max == 0 ||
        vg->lv_max > MAX_LV) return -LVM_EPARAM;

   size = vg->lv_max * sizeof ( lv_disk_t);
   if ( ( lv_this = malloc ( size)) == NULL) {
      fprintf ( stderr, "malloc error in %s [line %d]\n",
                        __FILE__, __LINE__);
      return -LVM_ELV_STORE_ALL_LV_OF_VG_MALLOC;
   }
   for ( l = 0; l < vg->lv_max; l++) {
      if ( vg->lv[l] != NULL) {
#ifdef DEBUG
         debug ( "lv_write_all_lv_of_vg -- copying vg->lv[%d] \"%s\"\n",
                  l, vg->lv[l]->lv_name);
#endif
         memcpy ( &lv_this[l],
                  ( lv_disk_tmp = lv_copy_to_disk ( vg->lv[l])),
                  sizeof ( lv_disk_t));
         free ( lv_disk_tmp);
      } else {
#ifdef DEBUG
         debug ( "lv_write_all_lv_of_vg -- copying EMPTY LV #%d\n", l);
#endif
         memset ( &lv_this[l], 0, sizeof ( lv_disk_t));
      }
   }

#ifdef DEBUG
   debug ( "lv_write_all_lv_of_vg -- storing %d byte of %d LVs on %s\n",
            size, size / sizeof ( lv_t), pv_name);
#endif

   if ( ( pvol = open ( pv_name, O_WRONLY)) == -1)
      ret = -LVM_ELV_STORE_ALL_LV_OF_VG_OPEN;
   else if ( lseek ( pvol, vg->pv[0]->lv_on_disk.base, SEEK_SET) != \
             vg->pv[0]->lv_on_disk.base)
      ret = -LVM_ELV_STORE_ALL_LV_OF_VG_LSEEK;
   else if ( write ( pvol, lv_this, size) != size)
      ret = -LVM_ELV_STORE_ALL_LV_OF_VG_WRITE;
   free ( lv_this);

   if ( pvol != -1) {
      fsync ( pvol);
      close ( pvol);
   }

#ifdef DEBUG
   debug ( "lv_write_all_lv_of_vg -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
