/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

/* internal function */
int vg_create_remove ( char *, vg_t *, int);


int vg_create ( char *vg_name, vg_t *vg) {
   return vg_create_remove ( vg_name, vg, VG_CREATE);
}


int vg_remove ( char *vg_name) {
   return vg_create_remove ( vg_name, NULL, VG_REMOVE);
}


int vg_create_remove ( char *vg_name, vg_t *vg, int cr) {
   int group = -1;
   int ret = 0;
   char group_file[NAME_LEN];

#ifdef DEBUG
   debug ( "vg_create_remove -- CALLED\n");
#endif

   switch ( cr) {
      case VG_CREATE:
         if ( vg_name == NULL ||
              vg == NULL ||
              vg_check_name ( vg_name) < 0 ||
              vg_check_consistency ( vg) < 0) return -LVM_EPARAM;
         break;

      case VG_REMOVE:
         if ( vg_name == NULL ||
              vg_check_name ( vg_name) < 0) return -LVM_EPARAM;
         break;

      default:
         return -LVM_EPARAM;
   }

   sprintf ( group_file, "/dev/%s/group%c", vg_name, 0);
   if ( ( group = open ( group_file, O_RDWR)) == -1)
      ret = -LVM_EVG_CREATE_REMOVE_OPEN;
   else {
#ifdef DEBUG
      debug ( "vg_create_remove -- IOCTL\n");
#endif
      if ( ( ret = ioctl ( group, cr, vg)) == -1) ret = -errno;;
#ifdef DEBUG
      debug ( "vg_create_remove -- IOCTL returned: %d\n", ret);
#endif
   }

   if ( group != -1) close ( group);

#ifdef DEBUG
   debug ( "vg_create_remove -- CALLED\n");
#endif
   return ret;
}
