/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March,October,November 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    10/8/97 - changed partition number to absolute
 *    11/7/97 - added debug info
 *
 */

#include <liblvm.h>

int pv_check_part ( char *dev_name) {
   int ret;

#ifdef DEBUG
   debug ( "pv_check_part -- CALLED with %s\n", dev_name);
#endif

   if ( dev_name == NULL || pv_check_name ( dev_name) < 0) ret = -LVM_EPARAM;
   else {
      ret = atoi ( dev_name + DISK_NAME_LEN);
      if ( ret < MIN_PART || ret > MAX_PART) ret = -LVM_EPV_CHECK_PART;
   }

#ifdef DEBUG
   debug ( "pv_check_part -- LEAVING with %d\n", ret);
#endif
   return ret;
}
