/*
 * Author: Heinz Mauelshagen, Germany
 *
 * June 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    10/18/1997 - fixed open of group file (always opened LVM_DEV before)
 *    29/04/1998 - changed to new lv_create_kdev_t()
 *
 */

#include <liblvm.h>

int pe_lock_internal ( char *, kdev_t, ulong, ushort, ushort, int);

int pe_lock ( char *vg_name, kdev_t dev, ulong pe,
              ushort vg_num, ushort lv_num) {
   return pe_lock_internal ( vg_name, dev, pe, vg_num, lv_num, LOCK_PE);
}

int pe_unlock ( char *vg_name) {
   return pe_lock_internal ( vg_name, 0, 0, 0, 0, UNLOCK_PE);
}

int pe_lock_internal ( char *vg_name, kdev_t dev, ulong pe,
                       ushort vg_num, ushort lv_num, int lock) {
   int group = -1;
   int ret = 0;
   char group_file[NAME_LEN] = { 0, };
   pe_lock_req_t pe_lock_req;

#ifdef DEBUG
   debug ( "pe_lock_internal -- CALLED for %s\n", vg_name);
#endif

   if ( lock != LOCK_PE && lock != UNLOCK_PE) return -LVM_EPARAM;
   if ( vg_name == NULL || vg_check_name ( vg_name) < 0) return -LVM_EPARAM;
   if ( lock == LOCK_PE) {
      if ( dev == 0 || pe == 0 || lv_num == 0) return -LVM_EPARAM;
   }

   sprintf ( group_file, "/dev/%s/group%c", vg_name, 0);
   if ( ( group = open ( group_file, O_RDONLY)) == -1) return -LVM_EPE_LOCK;

   pe_lock_req.lock = lock;
   if ( lock == LOCK_PE) {
      pe_lock_req.data.pv_dev = LOCK_PE;
      pe_lock_req.data.pv_dev = dev;
      pe_lock_req.data.lv_dev = lv_create_kdev_t ( vg_num, lv_num);
      pe_lock_req.data.pv_offset = pe;
   } else pe_lock_req.data.pv_dev = UNLOCK_PE;

   if ( ( ret = ioctl ( group,
                        PE_LOCK_UNLOCK,
                        &pe_lock_req)) == -1) ret = -errno;

   if ( group != -1) close ( group);

#ifdef DEBUG
   debug ( "pe_lock_internal -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
