/*
 * Author: Heinz Mauelshagen, Germany
 *
 * April 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

int lv_number_from_name_in_vg ( char *lv_name, vg_t *vg) {
   int l = 0, lv_num = -1;

#ifdef DEBUG
   debug ( "lv_number_from_name_in_vg -- CALLED\n");
#endif

   if ( lv_name == NULL || vg == NULL) return -LVM_EPARAM;

   for ( ; l < vg->lv_max; l++) {
      if ( vg->lv[l] == NULL) continue;
      if ( strcmp ( vg->lv[l]->lv_name, lv_name) == 0)
         lv_num = vg->lv[l]->lv_number;
   }

#ifdef DEBUG
   debug ( "lv_number_from_name -- LEAVING\n");
#endif
   return lv_num;
}
