/*
 * Author: Heinz Mauelshagen, Germany
 *
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */


#include <liblvm.h>


int lv_get_le_on_pv ( pv_t *pv, int lv_number) {
   int pe = 0;
   int ret = 0;

#ifdef DEBUG
   debug ( "lv_get_le_on_pv -- CALLED\n");
#endif

   if ( pv == NULL || pv_check_consistency ( pv) < 0 ||
        lv_number < 1) return -LVM_EPARAM;

   ret = 0;
   for ( pe = 0; pe < pv->pe_total; pe++) {
      if ( pv->pe[pe].lv_num == lv_number) ret++;
   }

#ifdef DEBUG
   debug ( "lv_get_le_on_pv -- LEAVING with %s\n", ret);
#endif
   return ret;
}
