/*
 * Author: Heinz Mauelshagen, Germany
 *
 * April 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

/* internal function */
int lv_extend_reduce ( vg_t *, lv_t *, char *, int);


int lv_extend ( vg_t *vg, lv_t *lv, char *lv_name) {
   return lv_extend_reduce ( vg, lv, lv_name, LV_EXTEND);
}


int lv_reduce ( vg_t *vg, lv_t *lv, char *lv_name) {
   return lv_extend_reduce ( vg, lv, lv_name, LV_REDUCE);
}


int lv_extend_reduce ( vg_t *vg, lv_t *lv, char *lv_name, int er) {
   int group = -1;
   int ret = 0;
   char group_file[NAME_LEN] = { 0, };
   lv_req_t req;

#ifdef DEBUG
   debug ( "lv_extend_reduce -- CALLED\n");
#endif

   if ( vg == NULL ||
        ( ret = vg_check_consistency ( vg)) < 0 ||
        lv == NULL ||
        ( ret = lv_check_consistency ( lv)) < 0 ||
        lv_name == NULL ||
        lv_check_name ( lv_name) < 0) {
      debug ( "lv_extend_reduce -- ret: %d\n", ret);
      return -LVM_EPARAM;
   }

   sprintf ( group_file, "/dev/%s/group%c", vg->vg_name, 0);
   strcpy ( req.lv_name, lv_name);
   req.lv = lv;
   if ( ( group = open ( group_file, O_RDWR)) == -1)
      return -LVM_ELV_EXTEND_REDUCE_OPEN;
#ifdef DEBUG
   debug ( "lv_extend_reduce -- BEFORE ioctl\n");
#endif
   if ( ( ret = ioctl ( group, er, &req)) == -1) ret = -errno;
   close ( group);
   if ( ret < 0) return ret;
#ifdef DEBUG
   debug ( "lv_extend_reduce -- BEFORE pv_change_all_pv_for_lv_of_vg\n");
#endif
   if ( er == LV_EXTEND)
      ret = pv_change_all_pv_for_lv_of_vg ( vg->vg_name, lv_name, vg);
   else
      ret = pv_change_all_pv_of_vg ( vg->vg_name, vg);

#ifdef DEBUG
   debug ( "lv_extend_reduce -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
