/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March 1997
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    05/05/1998 - optimized
 *
 */

#include <liblvm.h>

kdev_t pv_create_kdev_t ( char *dev_name) {
   int ret = 0;
   struct stat stat_b;

#ifdef DEBUG
   debug ( "pv_create_kdev_t -- CALLED\n");
#endif

   if ( dev_name == NULL || pv_check_name ( dev_name) < 0) return 0;

   if ( stat ( dev_name, &stat_b) == -1) ret = 0;
   else                                  ret = stat_b.st_rdev;

#ifdef DEBUG
   debug ( "pv_create_kdev_t -- LEAVING with ret: %X\n", ret);
#endif
   return ret;
}
