// Stream buffer classes -*- C++ -*-

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

//
// ISO C++ working draft paper: 27.5  Stream buffers
//

// Written by Per Bothner (bothner@cygnus.com).

#if 0
#include <libioP.h>  /* non-standard */
#endif

// Tell g++ that we want to get the implementation for this class.
// template class streambuf;

namespace std {

// Constructor.  Leave the whole work up to the C implementation.  The
// compiler takes care for the virtual jump table.
template <class _CharT, class _Traits>
  basic_streambuf<_CharT,_Traits>::basic_streambuf ()
{ }


// These are not-inlined member functions.
template <class _CharT, class _Traits>
  typename _Traits::int_type
  basic_streambuf<_CharT,_Traits>::sputbackc (_CharT)
{
  return 0;   // XXX
}


template <class _CharT, class _Traits>
  typename _Traits::int_type
  basic_streambuf<_CharT,_Traits>::sungetc ()
{
  return 0;  // XXX
}


// Now come the `streambuf' implementations of the virtual functions.
template <class _CharT, class _Traits>
  basic_streambuf<_CharT,_Traits>::~basic_streambuf ()
{
  // XXX
}


template <class _CharT, class _Traits>
  typename _Traits::int_type
  basic_streambuf<_CharT,_Traits>::overflow (typename _Traits::int_type)
{
  return _Traits::eof();
}

template <class _CharT, class _Traits>
  typename _Traits::int_type
  basic_streambuf<_CharT,_Traits>::underflow ()
{
  return _Traits::eof();
}


template <class _CharT, class _Traits>
  typename _Traits::int_type
  basic_streambuf<_CharT,_Traits>::uflow ()
{
  return _Traits::eof();
}


template <class _CharT, class _Traits>
  typename _Traits::int_type
  basic_streambuf<_CharT,_Traits>::pbackfail (typename _Traits::int_type c)
{
  return _Traits::eof();
}


template <class _CharT, class _Traits>
  streamsize
  basic_streambuf<_CharT,_Traits>::xsputn (const _CharT* s, streamsize n)
{
  return 0;
}


template <class _CharT, class _Traits>
  streamsize
  basic_streambuf<_CharT,_Traits>::xsgetn (_CharT* s, streamsize n)
{
  return 0;
}



template <class _CharT, class _Traits>
  typename _Traits::pos_type
  basic_streambuf<_CharT,_Traits>::seekoff (off_type, ios_base::seekdir,
                                            ios_base::openmode)
{
  typedef typename _Traits::pos_type _Pos;
  return _Pos();
}


template <class _CharT, class _Traits>
  typename _Traits::pos_type
  basic_streambuf<_CharT,_Traits>::seekpos (pos_type pos,
                                            ios_base::openmode mode)
{
  typedef typename _Traits::pos_type _Pos;
  return _Pos();
  return seekoff (off_type(pos), ios_base::beg, mode);
}

template <class _CharT, class _Traits>
  int
  basic_streambuf<_CharT,_Traits>::sync ()
{
  return 0;
}

template <class _CharT, class _Traits>
  basic_streambuf<_CharT,_Traits>*
  basic_streambuf<_CharT,_Traits>::setbuf (char_type* s, streamsize n)
{
  if (this->sync () == EOF)
    return NULL;

#if 0 /* XXX fixme */
  if (s == NULL || n == 0)
    {
      unbuffered (1);
      setb (_shortbuf, _shortbuf + 1, 0);  // XXX no _shortbuf member
    }
  else
    {
      unbuffered (0);
      setb (s, s + n, 0);
    }
#endif

  this->setp (0, 0);
  this->setg (0, 0, 0);
  return this;
}


#if 0

int
streambuf::doallocate ()
{
  return _IO_default_doallocate (this);
}


streamsize
streambuf::sys_read (char* /*buf*/, streamsize /*size*/)
{
  return 0;
}


streamsize
streambuf::sys_write (const char* /*buf*/, streamsize /*size*/)
{
  return 0;
}


#if 0 /* XXX what the hell is this? */
streampos
streambuf::sys_seek (streamoff, _seek_dir)
{
  return EOF;
}

#endif

int
streambuf::sys_close ()
{
  return 0;	/* Success; do nothing */
}


int
streambuf::sys_stat (void*)
{
#ifdef EIO
  errno = EIO;
#endif
  return -1;
}

#endif

template <class _CharT, class _Traits>
  int
  basic_streambuf<_CharT,_Traits>::showmanyc ()
{
  return -1;
}


#if 0
// inherited, don't need it.
template <class _CharT, class _Traits>
  void
  basic_streambuf<_CharT,_Traits>::imbue (const locale& loc)
{
  // XXX not done
}
#endif

} // namespace std
