/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.util;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class Version {
    private final String _name;
    private final boolean _beta;
    private final byte _major;
    private final byte _micro;
    private final byte _minor;

    public Version(String name, int major, int minor) {
        this(name, major, minor, 0);
    }

    public Version(String name, int major, int minor, int micro) {
        this(name, major, minor, micro, false);
    }

    public Version(String name, int major, int minor, int micro, boolean beta) {
        this._name = name;
        this._major = (byte)major;
        this._minor = (byte)minor;
        this._micro = (byte)micro;
        this._beta = beta;
    }

    public boolean isBeta() {
        return this._beta;
    }

    public byte getMajorNumber() {
        return this._major;
    }

    public byte getMicroNumber() {
        return this._micro;
    }

    public byte getMinorNumber() {
        return this._minor;
    }

    public String getName() {
        return this._name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Version) {
            Version other = (Version)o;
            return this._minor == other._minor && this._major == other._major && this._beta == other._beta && this._micro == other._micro && this._name.equals(other._name);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this._major;
        result = result * 37 + this._minor;
        result = result * 37 + this._micro;
        result = result * 37 + (this._beta ? 1 : 2);
        return this._name.hashCode() + result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(10);
        buf.append(this._major);
        buf.append('.');
        buf.append(this._minor);
        if (this._beta) {
            buf.append('b');
        } else {
            buf.append('.');
        }
        buf.append(this._micro);
        return buf.toString();
    }

    public static Version valueOf(String version) {
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern regexp = null;
        try {
            regexp = compiler.compile("(\\d).(\\d)(?:([.b])(\\d+))?", 16);
        }
        catch (MalformedPatternException neverOccurs) {
            // empty catch block
        }
        if (matcher.matches(version, regexp)) {
            MatchResult result = matcher.getMatch();
            int major = Integer.parseInt(result.group(1));
            int minor = Integer.parseInt(result.group(2));
            int micro = 0;
            boolean beta = false;
            if (result.groups() == 5) {
                beta = result.group(3).indexOf(98) > -1;
                micro = Integer.parseInt(result.group(4));
            }
            return new Version(null, major, minor, micro, beta);
        }
        throw new IllegalArgumentException("invalid version information -- " + version);
    }
}

