/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.storage;

import java.io.Serializable;

public final class Project
implements Serializable {
    static final long serialVersionUID = -4874682073931915199L;
    private final String _name;
    private String _description;

    public Project(String name, String description) {
        this.setDescription(description);
        this.validate(name, '\\');
        this.validate(name, '/');
        this.validate(name, ':');
        this.validate(name, '*');
        this.validate(name, '?');
        this.validate(name, '\"');
        this.validate(name, '\'');
        this.validate(name, '<');
        this.validate(name, '>');
        this.validate(name, '|');
        this._name = name;
    }

    public void setDescription(String description) {
        if (description.length() > 256) {
            throw new IllegalArgumentException("description exceeds maximum of 256 -- " + description.length());
        }
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public String getName() {
        return this._name;
    }

    public boolean equals(Object o) {
        if (o instanceof Project) {
            return this._name.equals(((Project)o)._name);
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    private void validate(String name, char character) {
        if (name.indexOf(character) > -1) {
            throw new IllegalArgumentException("invalid character found -- " + character);
        }
    }
}

