/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;
import java.util.List;

final class RightParenthesisPrinter
extends AbstractPrinter {
    private static final RightParenthesisPrinter INSTANCE = new RightParenthesisPrinter();

    private RightParenthesisPrinter() {
    }

    public static RightParenthesisPrinter getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        if (out.mode == 1) {
            if (settings.getBoolean(ConventionKeys.LINE_WRAP_PAREN_GROUPING, false)) {
                List parentheses = out.state.parentheses;
                int size = parentheses.size();
                for (int i = 0; i < size; ++i) {
                    Object parenthesis = parentheses.get(i);
                    if (parenthesis != node) continue;
                    out.printNewline();
                    if (settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                        out.state.markers.remove(out.state.markers.getLast());
                    } else {
                        out.unindent();
                    }
                    this.printIndentation(out);
                    parentheses.remove(i);
                    break;
                }
            }
        }
        this.printCommentsBefore(node, false, out);
        if (settings.getBoolean(ConventionKeys.PADDING_PAREN, false)) {
            out.print(" )", 85);
        } else {
            out.print(")", 85);
        }
        this.printCommentsAfter(node, false, false, out);
    }
}

