/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.BlockStatementPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class IfElsePrinter
extends BlockStatementPrinter {
    private static final Printer INSTANCE = new IfElsePrinter();

    protected IfElsePrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        switch (out.last) {
            case 93: {
                out.print(" ", 92);
            }
        }
        boolean spaceBefore = settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true);
        int offset = 1;
        offset = spaceBefore ? out.print("if ", 92) : out.print("if", 92);
        this.trackPosition((JavaNode)node, out.line, offset, out);
        AST lparen = node.getFirstChild();
        boolean insertBraces = settings.getBoolean(ConventionKeys.BRACE_INSERT_IF_ELSE, true);
        JavaNode rparen = this.printExpressionList(lparen, insertBraces, out);
        AST body = rparen.getNextSibling();
        boolean leftBraceNewline = settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false);
        boolean rightBraceNewline = settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false);
        boolean hasBraces = body.getType() == 11;
        out.last = 92;
        JavaNode next = (JavaNode)body.getNextSibling();
        if (hasBraces) {
            PrinterFactory.create(body).print(body, out);
        } else if (insertBraces) {
            if (out.pendingComment == null) {
                out.printLeftBrace(leftBraceNewline && !out.newline, true, true);
            } else {
                out.printLeftBrace(false, false);
                rparen.setHiddenAfter(out.pendingComment);
                this.printCommentsAfter(rparen, false, true, out);
                out.pendingComment = null;
            }
            PrinterFactory.create(body).print(body, out);
            out.printRightBrace(rightBraceNewline || next == null);
        } else {
            if (!out.newline) {
                out.printNewline();
            }
            out.indent();
            PrinterFactory.create(body).print(body, out);
            out.unindent();
        }
        if (next != null) {
            this.printCommentsBefore(next, out);
            if (!out.newline && out.last == 8) {
                out.print(out.getString(settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER, 1)), 153);
            }
            offset = out.print("else", 93);
            this.trackPosition(next, out.line, offset, out);
            JavaNode block = (JavaNode)next.getNextSibling();
            switch (block.getType()) {
                case 11: {
                    this.printCommentsAfter(next, false, !leftBraceNewline, out);
                    out.last = 92;
                    PrinterFactory.create(block).print(block, out);
                    break;
                }
                case 92: {
                    out.last = 93;
                    this.print(block, out);
                    break;
                }
                default: {
                    if (insertBraces) {
                        out.pendingComment = next.getCommentAfter();
                        if (out.pendingComment == null) {
                            this.printCommentsAfter(next, false, !leftBraceNewline, out);
                            out.printLeftBrace(rightBraceNewline, false, !rightBraceNewline && !out.newline);
                            out.printNewline();
                        } else {
                            out.printLeftBrace(false, false);
                            this.printCommentsAfter(next, false, true, out);
                        }
                        PrinterFactory.create(block).print(block, out);
                        out.printRightBrace();
                        break;
                    }
                    this.printCommentsAfter(next, false, false, out);
                    out.printNewline();
                    out.indent();
                    PrinterFactory.create(block).print(block, out);
                    out.unindent();
                }
            }
        }
        out.last = 8;
    }

    private boolean isCommentBefore(JavaNode elseNode) {
        JavaNode slist = elseNode.getPreviousSibling();
        JavaNode rcurly = null;
        block3: for (AST child = slist.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 8: {
                    if (child.getNextSibling() != null) continue block3;
                    rcurly = (JavaNode)child;
                }
            }
        }
        if (rcurly != null) {
            return rcurly.hasCommentsAfter();
        }
        return false;
    }
}

