/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.io;

import de.hunsicker.util.ResourceBundleFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.MessageFormat;

public class FileBackup {
    private static final String BUNDLE_NAME = "de.hunsicker.io.Bundle";
    public static final int NUMBERED = 2;
    public static final int SIMPLE = 1;

    private FileBackup() {
    }

    public static synchronized File create(File file, File directory) throws IOException {
        return FileBackup.create(file, directory, 2, null, 5);
    }

    public static synchronized File create(File file, File directory, int backupLevel) throws IOException {
        return FileBackup.create(file, directory, 2, null, backupLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized File create(String content, String filename, File directory, int backupLevel) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            Object[] args = new Object[]{directory};
            throw new IOException(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("COULD_NOT_CREATE_DIRECTORY"), args));
        }
        int highestBackup = FileBackup.getLatestRevision(filename, directory);
        File backup = new File(directory + File.separator + FileBackup.getVersionName(filename, highestBackup + 1));
        Writer out = null;
        try {
            out = new BufferedWriter(new FileWriter(backup));
            out.write(content);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        FileBackup.removeObsoleteRevisions(highestBackup + 1, backupLevel, filename, directory);
        return backup;
    }

    public static synchronized File create(File file, File directory, int backupType, String suffix, int backupLevel) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            Object[] args = new Object[]{directory};
            throw new IOException(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("COULD_NOT_CREATE_DIRECTORY"), args));
        }
        File backup = null;
        switch (backupType) {
            case 1: {
                if (suffix == null) {
                    suffix = ".bak";
                } else if (!suffix.startsWith(".")) {
                    suffix = "." + suffix;
                }
                backup = new File(file.getAbsolutePath() + suffix);
                FileBackup.copy(file, backup);
                return backup;
            }
            case 2: {
                int highestBackup = FileBackup.getLatestRevision(file.getName(), directory);
                backup = new File(directory + File.separator + FileBackup.getVersionName(file, highestBackup + 1));
                FileBackup.copy(file, backup);
                FileBackup.removeObsoleteRevisions(highestBackup + 1, backupLevel, file.getName(), directory);
            }
        }
        return backup;
    }

    private static int getLatestRevision(String filename, File dir) {
        if (dir == null) {
            return 0;
        }
        File[] files = dir.listFiles();
        int result = 0;
        for (int i = 0; i < files.length; ++i) {
            int revision;
            String name = files[i].getName();
            if (!name.startsWith(filename) || (revision = FileBackup.getRevision(name)) <= result) continue;
            result = revision;
        }
        return result;
    }

    private static boolean isNumber(String str) {
        if (str == null) {
            return false;
        }
        int letters = 0;
        int size = str.length();
        for (int i = 0; i < size; ++i) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') continue;
            ++letters;
        }
        return letters <= 1 && (letters != 1 || str.length() != 1);
    }

    private static int getRevision(String filename) {
        int startOffset = filename.indexOf(126);
        int endOffset = filename.indexOf(126, startOffset + 1);
        while (startOffset < endOffset && startOffset > -1 && endOffset > -1) {
            int revision;
            String result = filename.substring(startOffset + 1, endOffset);
            startOffset = filename.indexOf(126, endOffset);
            endOffset = filename.indexOf(126, startOffset + 1);
            if (!FileBackup.isNumber(result) || (revision = Integer.parseInt(result)) <= 0) continue;
            return revision;
        }
        return 0;
    }

    private static String getVersionName(File file, int revision) {
        return FileBackup.getVersionName(file.getName(), revision);
    }

    private static String getVersionName(String filename, int revision) {
        StringBuffer buf = new StringBuffer(15);
        buf.append(filename);
        buf.append('~');
        buf.append(revision);
        buf.append('~');
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File source, File target) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(source));
            out = new BufferedOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                out.write(buffer, 0, count);
            } while ((count = in.read(buffer, 0, buffer.length)) != -1);
            out.close();
            target.setLastModified(source.lastModified());
        }
        finally {
            in.close();
            out.close();
        }
    }

    private static void removeObsoleteRevisions(int currentRevision, int backupLevel, String filename, File directory) {
        File[] files = directory.listFiles();
        if (backupLevel > 0) {
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (!name.startsWith(filename) || FileBackup.getRevision(name) > currentRevision - backupLevel) continue;
                files[i].delete();
            }
        }
    }
}

