/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.antlr;

import de.hunsicker.antlr.ANTLRGrammarParseBehavior;
import de.hunsicker.antlr.CodeGenerator;
import de.hunsicker.antlr.CommonToken;
import de.hunsicker.antlr.Grammar;
import de.hunsicker.antlr.ImportVocabTokenManager;
import de.hunsicker.antlr.LLkAnalyzer;
import de.hunsicker.antlr.LexerGrammar;
import de.hunsicker.antlr.ParserGrammar;
import de.hunsicker.antlr.RuleSymbol;
import de.hunsicker.antlr.SemanticException;
import de.hunsicker.antlr.SimpleTokenManager;
import de.hunsicker.antlr.StringLiteralSymbol;
import de.hunsicker.antlr.StringUtils;
import de.hunsicker.antlr.Token;
import de.hunsicker.antlr.TokenManager;
import de.hunsicker.antlr.TokenSymbol;
import de.hunsicker.antlr.Tool;
import de.hunsicker.antlr.TreeWalkerGrammar;
import de.hunsicker.antlr.collections.impl.BitSet;
import java.util.Hashtable;

public class DefineGrammarSymbols
implements ANTLRGrammarParseBehavior {
    protected Hashtable grammars = new Hashtable();
    protected Hashtable tokenManagers = new Hashtable();
    protected Grammar grammar;
    protected Tool tool;
    LLkAnalyzer analyzer;
    String[] args;
    static final String DEFAULT_TOKENMANAGER_NAME = "*default";
    protected Hashtable headerActions = new Hashtable();
    Token thePreambleAction = new CommonToken(0, "");
    String language = "Java";
    protected int numLexers = 0;
    protected int numParsers = 0;
    protected int numTreeParsers = 0;

    public DefineGrammarSymbols(Tool tool_, String[] args_, LLkAnalyzer analyzer_) {
        this.tool = tool_;
        this.args = args_;
        this.analyzer = analyzer_;
    }

    public void _refStringLiteral(Token lit, Token label, int autoGenType, boolean lastInRule) {
        if (!(this.grammar instanceof LexerGrammar)) {
            String str = lit.getText();
            if (this.grammar.tokenManager.getTokenSymbol(str) != null) {
                return;
            }
            StringLiteralSymbol sl = new StringLiteralSymbol(str);
            int tt = this.grammar.tokenManager.nextTokenType();
            sl.setTokenType(tt);
            this.grammar.tokenManager.define(sl);
        }
    }

    public void _refToken(Token assignId, Token t, Token label, Token args, boolean inverted, int autoGenType, boolean lastInRule) {
        String id = t.getText();
        if (!this.grammar.tokenManager.tokenDefined(id)) {
            int tt = this.grammar.tokenManager.nextTokenType();
            TokenSymbol ts = new TokenSymbol(id);
            ts.setTokenType(tt);
            this.grammar.tokenManager.define(ts);
        }
    }

    public void abortGrammar() {
        if (this.grammar != null && this.grammar.getClassName() != null) {
            this.grammars.remove(this.grammar.getClassName());
        }
        this.grammar = null;
    }

    public void beginAlt(boolean doAST_) {
    }

    public void beginChildList() {
    }

    public void beginExceptionGroup() {
    }

    public void beginExceptionSpec(Token label) {
    }

    public void beginSubRule(Token label, Token start, boolean not) {
    }

    public void beginTree(Token tok) throws SemanticException {
    }

    public void defineRuleName(Token r, String access, boolean ruleAutoGen, String docComment) throws SemanticException {
        RuleSymbol rs;
        String id = r.getText();
        if (r.type == 24) {
            id = CodeGenerator.encodeLexerRuleName(id);
            if (!this.grammar.tokenManager.tokenDefined(r.getText())) {
                int tt = this.grammar.tokenManager.nextTokenType();
                TokenSymbol ts = new TokenSymbol(r.getText());
                ts.setTokenType(tt);
                this.grammar.tokenManager.define(ts);
            }
        }
        if (this.grammar.isDefined(id)) {
            rs = (RuleSymbol)this.grammar.getSymbol(id);
            if (rs.isDefined()) {
                this.tool.error("redefinition of rule " + id, this.grammar.getFilename(), r.getLine(), r.getColumn());
            }
        } else {
            rs = new RuleSymbol(id);
            this.grammar.define(rs);
        }
        rs.setDefined();
        rs.access = access;
        rs.comment = docComment;
    }

    public void defineToken(Token tokname, Token tokliteral) {
        String name = null;
        String literal = null;
        if (tokname != null) {
            name = tokname.getText();
        }
        if (tokliteral != null) {
            literal = tokliteral.getText();
        }
        if (literal != null) {
            TokenSymbol ts;
            StringLiteralSymbol sl = (StringLiteralSymbol)this.grammar.tokenManager.getTokenSymbol(literal);
            if (sl != null) {
                if (name == null || sl.getLabel() != null) {
                    this.tool.warning("Redefinition of literal in tokens {...}: " + literal, this.grammar.getFilename(), tokliteral.getLine(), tokliteral.getColumn());
                    return;
                }
                if (name != null) {
                    sl.setLabel(name);
                    this.grammar.tokenManager.mapToTokenSymbol(name, sl);
                }
            }
            if (name != null && (ts = this.grammar.tokenManager.getTokenSymbol(name)) != null) {
                if (ts instanceof StringLiteralSymbol) {
                    this.tool.warning("Redefinition of token in tokens {...}: " + name, this.grammar.getFilename(), tokliteral.getLine(), tokliteral.getColumn());
                    return;
                }
                int ttype = ts.getTokenType();
                sl = new StringLiteralSymbol(literal);
                sl.setTokenType(ttype);
                sl.setLabel(name);
                this.grammar.tokenManager.define(sl);
                this.grammar.tokenManager.mapToTokenSymbol(name, sl);
                return;
            }
            sl = new StringLiteralSymbol(literal);
            int tt = this.grammar.tokenManager.nextTokenType();
            sl.setTokenType(tt);
            sl.setLabel(name);
            this.grammar.tokenManager.define(sl);
            if (name != null) {
                this.grammar.tokenManager.mapToTokenSymbol(name, sl);
            }
        } else {
            if (this.grammar.tokenManager.tokenDefined(name)) {
                this.tool.warning("Redefinition of token in tokens {...}: " + name, this.grammar.getFilename(), tokname.getLine(), tokname.getColumn());
                return;
            }
            int tt = this.grammar.tokenManager.nextTokenType();
            TokenSymbol ts = new TokenSymbol(name);
            ts.setTokenType(tt);
            this.grammar.tokenManager.define(ts);
        }
    }

    public void endAlt() {
    }

    public void endChildList() {
    }

    public void endExceptionGroup() {
    }

    public void endExceptionSpec() {
    }

    public void endGrammar() {
    }

    public void endOptions() {
        if (this.grammar.exportVocab == null && this.grammar.importVocab == null) {
            this.grammar.exportVocab = this.grammar.getClassName();
            if (this.tokenManagers.containsKey(DEFAULT_TOKENMANAGER_NAME)) {
                this.grammar.exportVocab = DEFAULT_TOKENMANAGER_NAME;
                TokenManager tm = (TokenManager)this.tokenManagers.get(DEFAULT_TOKENMANAGER_NAME);
                this.grammar.setTokenManager(tm);
                return;
            }
            SimpleTokenManager tm = new SimpleTokenManager(this.grammar.exportVocab, this.tool);
            this.grammar.setTokenManager(tm);
            this.tokenManagers.put(this.grammar.exportVocab, tm);
            this.tokenManagers.put(DEFAULT_TOKENMANAGER_NAME, tm);
            return;
        }
        if (this.grammar.exportVocab == null && this.grammar.importVocab != null) {
            this.grammar.exportVocab = this.grammar.getClassName();
            if (this.grammar.importVocab.equals(this.grammar.exportVocab)) {
                this.tool.warning("Grammar " + this.grammar.getClassName() + " cannot have importVocab same as default output vocab (grammar name); ignored.");
                this.grammar.importVocab = null;
                this.endOptions();
                return;
            }
            if (this.tokenManagers.containsKey(this.grammar.importVocab)) {
                TokenManager tm = (TokenManager)this.tokenManagers.get(this.grammar.importVocab);
                TokenManager dup = (TokenManager)tm.clone();
                dup.setName(this.grammar.exportVocab);
                dup.setReadOnly(false);
                this.grammar.setTokenManager(dup);
                this.tokenManagers.put(this.grammar.exportVocab, dup);
                return;
            }
            ImportVocabTokenManager tm = new ImportVocabTokenManager(this.grammar, this.grammar.importVocab + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt, this.grammar.exportVocab, this.tool);
            tm.setReadOnly(false);
            this.tokenManagers.put(this.grammar.exportVocab, tm);
            this.grammar.setTokenManager(tm);
            if (!this.tokenManagers.containsKey(DEFAULT_TOKENMANAGER_NAME)) {
                this.tokenManagers.put(DEFAULT_TOKENMANAGER_NAME, tm);
            }
            return;
        }
        if (this.grammar.exportVocab != null && this.grammar.importVocab == null) {
            if (this.tokenManagers.containsKey(this.grammar.exportVocab)) {
                TokenManager tm = (TokenManager)this.tokenManagers.get(this.grammar.exportVocab);
                this.grammar.setTokenManager(tm);
                return;
            }
            SimpleTokenManager tm = new SimpleTokenManager(this.grammar.exportVocab, this.tool);
            this.grammar.setTokenManager(tm);
            this.tokenManagers.put(this.grammar.exportVocab, tm);
            if (!this.tokenManagers.containsKey(DEFAULT_TOKENMANAGER_NAME)) {
                this.tokenManagers.put(DEFAULT_TOKENMANAGER_NAME, tm);
            }
            return;
        }
        if (this.grammar.exportVocab != null && this.grammar.importVocab != null) {
            if (this.grammar.importVocab.equals(this.grammar.exportVocab)) {
                this.tool.error("exportVocab of " + this.grammar.exportVocab + " same as importVocab; probably not what you want");
            }
            if (this.tokenManagers.containsKey(this.grammar.importVocab)) {
                TokenManager tm = (TokenManager)this.tokenManagers.get(this.grammar.importVocab);
                TokenManager dup = (TokenManager)tm.clone();
                dup.setName(this.grammar.exportVocab);
                dup.setReadOnly(false);
                this.grammar.setTokenManager(dup);
                this.tokenManagers.put(this.grammar.exportVocab, dup);
                return;
            }
            ImportVocabTokenManager tm = new ImportVocabTokenManager(this.grammar, this.grammar.importVocab + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt, this.grammar.exportVocab, this.tool);
            tm.setReadOnly(false);
            this.tokenManagers.put(this.grammar.exportVocab, tm);
            this.grammar.setTokenManager(tm);
            if (!this.tokenManagers.containsKey(DEFAULT_TOKENMANAGER_NAME)) {
                this.tokenManagers.put(DEFAULT_TOKENMANAGER_NAME, tm);
            }
            return;
        }
    }

    public void endRule(String r) {
    }

    public void endSubRule() {
    }

    public void endTree() {
    }

    public void hasError() {
    }

    public void noASTSubRule() {
    }

    public void oneOrMoreSubRule() {
    }

    public void optionalSubRule() {
    }

    public void setUserExceptions(String thr) {
    }

    public void refAction(Token action) {
    }

    public void refArgAction(Token action) {
    }

    public void refCharLiteral(Token lit, Token label, boolean inverted, int autoGenType, boolean lastInRule) {
    }

    public void refCharRange(Token t1, Token t2, Token label, int autoGenType, boolean lastInRule) {
    }

    public void refElementOption(Token option, Token value) {
    }

    public void refTokensSpecElementOption(Token tok, Token option, Token value) {
    }

    public void refExceptionHandler(Token exTypeAndName, Token action) {
    }

    public void refHeaderAction(Token name, Token act) {
        String key = name == null ? "" : StringUtils.stripFrontBack(name.getText(), "\"", "\"");
        if (this.headerActions.containsKey(key)) {
            if (key.equals("")) {
                this.tool.error(act.getLine() + ": header action already defined");
            } else {
                this.tool.error(act.getLine() + ": header action '" + key + "' already defined");
            }
        }
        this.headerActions.put(key, act);
    }

    public String getHeaderAction(String name) {
        Token t = (Token)this.headerActions.get(name);
        if (t == null) {
            return "";
        }
        return t.getText();
    }

    public void refInitAction(Token action) {
    }

    public void refMemberAction(Token act) {
    }

    public void refPreambleAction(Token act) {
        this.thePreambleAction = act;
    }

    public void refReturnAction(Token returnAction) {
    }

    public void refRule(Token idAssign, Token r, Token label, Token args, int autoGenType) {
        String id = r.getText();
        if (r.type == 24) {
            id = CodeGenerator.encodeLexerRuleName(id);
        }
        if (!this.grammar.isDefined(id)) {
            this.grammar.define(new RuleSymbol(id));
        }
    }

    public void refSemPred(Token pred) {
    }

    public void refStringLiteral(Token lit, Token label, int autoGenType, boolean lastInRule) {
        this._refStringLiteral(lit, label, autoGenType, lastInRule);
    }

    public void refToken(Token assignId, Token t, Token label, Token args, boolean inverted, int autoGenType, boolean lastInRule) {
        this._refToken(assignId, t, label, args, inverted, autoGenType, lastInRule);
    }

    public void refTokenRange(Token t1, Token t2, Token label, int autoGenType, boolean lastInRule) {
        if (t1.getText().charAt(0) == '\"') {
            this.refStringLiteral(t1, null, 1, lastInRule);
        } else {
            this._refToken(null, t1, null, null, false, 1, lastInRule);
        }
        if (t2.getText().charAt(0) == '\"') {
            this._refStringLiteral(t2, null, 1, lastInRule);
        } else {
            this._refToken(null, t2, null, null, false, 1, lastInRule);
        }
    }

    public void refTreeSpecifier(Token treeSpec) {
    }

    public void refWildcard(Token t, Token label, int autoGenType) {
    }

    public void reset() {
        this.grammar = null;
    }

    public void setArgOfRuleRef(Token argaction) {
    }

    public void setCharVocabulary(BitSet b) {
        ((LexerGrammar)this.grammar).setCharVocabulary(b);
    }

    public void setFileOption(Token key, Token value, String filename) {
        if (key.getText().equals("language")) {
            if (value.getType() == 6) {
                this.language = StringUtils.stripBack(StringUtils.stripFront(value.getText(), '\"'), '\"');
            } else if (value.getType() == 24 || value.getType() == 28) {
                this.language = value.getText();
            } else {
                this.tool.error("language option must be string or identifier", filename, value.getLine(), value.getColumn());
            }
        } else if (key.getText().equals("mangleLiteralPrefix")) {
            if (value.getType() == 6) {
                Tool.literalsPrefix = StringUtils.stripFrontBack(value.getText(), "\"", "\"");
            } else {
                this.tool.error("mangleLiteralPrefix option must be string", filename, value.getLine(), value.getColumn());
            }
        } else if (key.getText().equals("upperCaseMangledLiterals")) {
            if (value.getText().equals("true")) {
                Tool.upperCaseMangledLiterals = true;
            } else if (value.getText().equals("false")) {
                Tool.upperCaseMangledLiterals = false;
            } else {
                this.grammar.antlrTool.error("Value for upperCaseMangledLiterals must be true or false", filename, key.getLine(), key.getColumn());
            }
        } else if (key.getText().equals("namespace") || key.getText().equals("namespaceStd") || key.getText().equals("namespaceAntlr") || key.getText().equals("genHashLines")) {
            if (!this.language.equals("Cpp")) {
                this.tool.error(key.getText() + " option only valid for C++", filename, key.getLine(), key.getColumn());
            } else if (key.getText().equals("genHashLines")) {
                if (!value.getText().equals("true") && !value.getText().equals("false")) {
                    this.tool.error("genHashLines option must be true or false", filename, value.getLine(), value.getColumn());
                }
                this.tool.genHashLines = value.getText().equals("true");
            } else if (value.getType() != 6) {
                this.tool.error(key.getText() + " option must be a string", filename, value.getLine(), value.getColumn());
            } else if (key.getText().equals("namespace")) {
                this.tool.setNameSpace(value.getText());
            } else if (key.getText().equals("namespaceStd")) {
                this.tool.namespaceStd = value.getText();
            } else if (key.getText().equals("namespaceAntlr")) {
                this.tool.namespaceAntlr = value.getText();
            }
        } else {
            this.tool.error("Invalid file-level option: " + key.getText(), filename, key.getLine(), value.getColumn());
        }
    }

    public void setGrammarOption(Token key, Token value) {
        if (key.getText().equals("tokdef") || key.getText().equals("tokenVocabulary")) {
            this.tool.error("tokdef/tokenVocabulary options are invalid >= ANTLR 2.6.0.\n  Use importVocab/exportVocab instead.  Please see the documentation.\n  The previous options were so heinous that Terence changed the whole\n  vocabulary mechanism; it was better to change the names rather than\n  subtly change the functionality of the known options.  Sorry!", this.grammar.getFilename(), value.getLine(), value.getColumn());
        } else if (key.getText().equals("literal") && this.grammar instanceof LexerGrammar) {
            this.tool.error("the literal option is invalid >= ANTLR 2.6.0.\n  Use the \"tokens {...}\" mechanism instead.", this.grammar.getFilename(), value.getLine(), value.getColumn());
        } else if (key.getText().equals("exportVocab")) {
            if (value.getType() == 28 || value.getType() == 24) {
                this.grammar.exportVocab = value.getText();
            } else {
                this.tool.error("exportVocab must be an identifier", this.grammar.getFilename(), value.getLine(), value.getColumn());
            }
        } else if (key.getText().equals("importVocab")) {
            if (value.getType() == 28 || value.getType() == 24) {
                this.grammar.importVocab = value.getText();
            } else {
                this.tool.error("importVocab must be an identifier", this.grammar.getFilename(), value.getLine(), value.getColumn());
            }
        } else {
            this.grammar.setOption(key.getText(), value);
        }
    }

    public void setRuleOption(Token key, Token value) {
    }

    public void setSubruleOption(Token key, Token value) {
    }

    public void startLexer(String file, Token name, String superClass, String doc) {
        if (this.numLexers > 0) {
            this.tool.panic("You may only have one lexer per grammar file: class " + name.getText());
        }
        ++this.numLexers;
        this.reset();
        Grammar g = (Grammar)this.grammars.get(name);
        if (g != null) {
            if (!(g instanceof LexerGrammar)) {
                this.tool.panic("'" + name.getText() + "' is already defined as a non-lexer");
            } else {
                this.tool.panic("Lexer '" + name.getText() + "' is already defined");
            }
        } else {
            LexerGrammar lg = new LexerGrammar(name.getText(), this.tool, superClass);
            lg.comment = doc;
            lg.processArguments(this.args);
            lg.setFilename(file);
            this.grammars.put(lg.getClassName(), lg);
            lg.preambleAction = this.thePreambleAction;
            this.thePreambleAction = new CommonToken(0, "");
            this.grammar = lg;
        }
    }

    public void startParser(String file, Token name, String superClass, String doc) {
        if (this.numParsers > 0) {
            this.tool.panic("You may only have one parser per grammar file: class " + name.getText());
        }
        ++this.numParsers;
        this.reset();
        Grammar g = (Grammar)this.grammars.get(name);
        if (g != null) {
            if (!(g instanceof ParserGrammar)) {
                this.tool.panic("'" + name.getText() + "' is already defined as a non-parser");
            } else {
                this.tool.panic("Parser '" + name.getText() + "' is already defined");
            }
        } else {
            this.grammar = new ParserGrammar(name.getText(), this.tool, superClass);
            this.grammar.comment = doc;
            this.grammar.processArguments(this.args);
            this.grammar.setFilename(file);
            this.grammars.put(this.grammar.getClassName(), this.grammar);
            this.grammar.preambleAction = this.thePreambleAction;
            this.thePreambleAction = new CommonToken(0, "");
        }
    }

    public void startTreeWalker(String file, Token name, String superClass, String doc) {
        if (this.numTreeParsers > 0) {
            this.tool.panic("You may only have one tree parser per grammar file: class " + name.getText());
        }
        ++this.numTreeParsers;
        this.reset();
        Grammar g = (Grammar)this.grammars.get(name);
        if (g != null) {
            if (!(g instanceof TreeWalkerGrammar)) {
                this.tool.panic("'" + name.getText() + "' is already defined as a non-tree-walker");
            } else {
                this.tool.panic("Tree-walker '" + name.getText() + "' is already defined");
            }
        } else {
            this.grammar = new TreeWalkerGrammar(name.getText(), this.tool, superClass);
            this.grammar.comment = doc;
            this.grammar.processArguments(this.args);
            this.grammar.setFilename(file);
            this.grammars.put(this.grammar.getClassName(), this.grammar);
            this.grammar.preambleAction = this.thePreambleAction;
            this.thePreambleAction = new CommonToken(0, "");
        }
    }

    public void synPred() {
    }

    public void zeroOrMoreSubRule() {
    }
}

