/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.printer.AssignmentPrinter;
import de.hunsicker.jalopy.printer.BasicDeclarationPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class VariableDeclarationPrinter
extends BasicDeclarationPrinter {
    static final int OFFSET_NONE = -1;
    private static final Printer INSTANCE = new VariableDeclarationPrinter();

    protected VariableDeclarationPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        AST semi;
        boolean innerClass;
        block17: {
            JavaNode n;
            block18: {
                n = (JavaNode)node;
                if (out.state.anonymousInnerClass || n.hasJavadocComment()) break block17;
                if (!out.state.innerClass) break block18;
                if (!settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_INNER_CLASS, false)) break block17;
            }
            if (!JavaNodeHelper.isLocalVariable(node)) {
                this.addComment(n, out);
            }
        }
        this.printCommentsBefore(node, out);
        int last = out.last;
        AST modifiers = node.getFirstChild();
        PrinterFactory.create(modifiers).print(modifiers, out);
        AST type = modifiers.getNextSibling();
        PrinterFactory.create(type).print(type, out);
        boolean newChunk = false;
        if (out.mode == 1) {
            if (settings.getBoolean(ConventionKeys.ALIGN_VAR_IDENTS, false)) {
                newChunk = this.alignVariable(node, last, out);
            } else {
                AST next = node.getNextSibling();
                if (next == null || JavaNodeHelper.getFirstChild(node, 89) == null && next.getType() != 14) {
                    newChunk = true;
                }
            }
        }
        out.print(" ", 153);
        AST identifier = type.getNextSibling();
        PrinterFactory.create(identifier).print(identifier, out);
        AST assign = identifier.getNextSibling();
        if (assign != null) {
            if (type != null && "String".equals(type.getFirstChild().getText())) {
                switch (assign.getType()) {
                    case 89: {
                        if (this.isLongStringLiteral(assign, out)) {
                            AssignmentPrinter.getInstance().print(assign, true, out);
                            break;
                        }
                    }
                    default: {
                        PrinterFactory.create(assign).print(assign, out);
                        break;
                    }
                }
            } else {
                PrinterFactory.create(assign).print(assign, out);
            }
        }
        boolean bl = innerClass = out.last == 18;
        if (assign != null && (semi = assign.getNextSibling()) != null) {
            PrinterFactory.create(semi).print(semi, out);
        }
        if (newChunk) {
            out.state.assignOffset = -1;
        }
        out.last = innerClass ? 8 : 14;
    }

    boolean isNewChunk(AST node, int last) {
        JavaNode n = (JavaNode)node;
        if (settings.getBoolean(ConventionKeys.CHUNKS_BY_COMMENTS, true) && n.hasCommentsBefore()) {
            return true;
        }
        switch (last) {
            case 14: {
                int maxLinesBetween = settings.getInt(ConventionKeys.BLANK_LINES_KEEP_UP_TO, 1);
                if (maxLinesBetween <= 0) break;
                return settings.getBoolean(ConventionKeys.CHUNKS_BY_BLANK_LINES, true) && n.getStartLine() - n.getPreviousSibling().getStartLine() - 1 > maxLinesBetween;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isLongStringLiteral(AST node, NodeWriter out) throws IOException {
        boolean result = false;
        boolean possible = false;
        int lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        AST child = node.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 135: {
                    possible = true;
                    break;
                }
                case 149: {
                    if (!possible) return result;
                    if (out.column + child.getText().length() <= lineLength) return result;
                    return true;
                }
            }
            child = child.getFirstChild();
        }
        return result;
    }

    private boolean alignVariable(AST node, int last, NodeWriter out) throws IOException {
        boolean result = false;
        if (out.mode == 1) {
            AST next = node.getNextSibling();
            if ((last != 14 || out.state.variableOffset == -1) && next != null) {
                out.state.variableOffset = -1;
                result = true;
                switch (next.getType()) {
                    case 14: {
                        TestNodeWriter tester = out.testers.get();
                        int length = -1;
                        block9: for (AST def = node; def != null; def = def.getNextSibling()) {
                            switch (def.getType()) {
                                case 14: {
                                    tester.reset();
                                    AST defModifier = def.getFirstChild();
                                    AST defType = defModifier.getNextSibling();
                                    PrinterFactory.create(defModifier).print(defModifier, tester);
                                    PrinterFactory.create(defType).print(defType, tester);
                                    if (tester.length > length) {
                                        length = tester.length;
                                    }
                                    if (!this.isNewChunk(def.getNextSibling(), 14)) continue block9;
                                    break block9;
                                }
                            }
                        }
                        out.testers.release(tester);
                        out.state.variableOffset = length + out.getIndentLength() + 1;
                        break;
                    }
                }
            }
            if (out.state.variableOffset != -1) {
                if (out.state.variableOffset > out.column) {
                    out.print(out.getString(out.state.variableOffset - out.column), 153);
                }
                switch (next.getType()) {
                    case 14: {
                        if (!this.isNewChunk((JavaNode)next, last)) break;
                        out.state.variableOffset = -1;
                        result = true;
                        break;
                    }
                    default: {
                        out.state.variableOffset = -1;
                        result = true;
                    }
                }
            }
        }
        return result;
    }
}

