/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class LeftParenthesisPrinter
extends AbstractPrinter {
    private static final LeftParenthesisPrinter INSTANCE = new LeftParenthesisPrinter();

    private LeftParenthesisPrinter() {
    }

    public static LeftParenthesisPrinter getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        if (settings.getBoolean(ConventionKeys.PADDING_PAREN, false)) {
            out.print("( ", 84);
        } else {
            out.print("(", 84);
        }
        this.printCommentsAfter(node, false, true, out);
        if (out.mode == 1) {
            if (settings.getBoolean(ConventionKeys.LINE_WRAP_PAREN_GROUPING, false)) {
                block0 : switch (node.getType()) {
                    case 84: {
                        JavaNode parent = ((JavaNode)node).getParent();
                        switch (parent.getType()) {
                            case 12: 
                            case 13: 
                            case 31: 
                            case 32: 
                            case 69: 
                            case 92: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 101: 
                            case 106: 
                            case 146: {
                                break block0;
                            }
                        }
                        this.wrap(node, parent, out);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void wrap(AST leftParen, JavaNode parent, NodeWriter out) throws IOException {
        int lineLength;
        TestNodeWriter tester = out.testers.get();
        AST rightParen = null;
        int count = 0;
        block4: for (AST child = leftParen; child != null; child = child.getNextSibling()) {
            PrinterFactory.create(child).print(child, tester);
            switch (child.getType()) {
                case 84: {
                    ++count;
                    break;
                }
                case 85: {
                    if (--count != 0) break;
                    rightParen = child;
                    break block4;
                }
            }
        }
        if (out.column + tester.length > (lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80))) {
            out.printNewline();
            if (settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                out.state.markers.add(out.line, out.state.markers.getLast().column + out.indentSize);
            } else {
                out.indent();
            }
            out.state.parentheses.add(rightParen);
            this.printIndentation(out);
        }
        out.testers.release(tester);
    }
}

