/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.swing.util.SwingHelper;
import de.hunsicker.util.ResourceBundleFactory;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class NamingSettingsPage
extends AbstractSettingsPage {
    private static final String EMPTY_STRING = "".intern();
    private static final String BUNDLE_NAME = "de.hunsicker.jalopy.swing.Bundle";
    private JList _patternList;

    public NamingSettingsPage() {
        this.initialize();
    }

    NamingSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public void updateSettings() {
        ListModel model = this._patternList.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            PatternListEntry entry = (PatternListEntry)model.getElementAt(i);
            this.settings.put(entry.key, entry.pattern);
        }
    }

    private RegexpDialog create(Window owner) {
        if (owner instanceof Frame) {
            return new RegexpDialog((Frame)owner);
        }
        return new RegexpDialog((Dialog)owner);
    }

    private void initialize() {
        PatternListEntry[] entries = new PatternListEntry[]{new PatternListEntry(this.bundle.getString("LBL_PACKAGES"), null, ConventionKeys.REGEXP_PACKAGE, "[a-z]+(?:\\.[a-z]+)*"), new PatternListEntry(this.bundle.getString("LBL_CLASSES"), null, ConventionKeys.REGEXP_CLASS, "[A-Z][a-zA-Z0-9]+"), new PatternListEntry(this.bundle.getString("LBL_CLASSES"), "abstract", ConventionKeys.REGEXP_CLASS_ABSTRACT, "[A-Z][a-zA-Z0-9]+"), new PatternListEntry(this.bundle.getString("LBL_INTERFACES"), null, ConventionKeys.REGEXP_INTERFACE, "[A-Z][a-zA-Z0-9]+"), new PatternListEntry(this.bundle.getString("LBL_FIELDS"), "public", ConventionKeys.REGEXP_FIELD_PUBLIC, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_FIELDS"), "protected", ConventionKeys.REGEXP_FIELD_PROTECTED, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_FIELDS"), "default", ConventionKeys.REGEXP_FIELD_DEFAULT, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_FIELDS"), "private", ConventionKeys.REGEXP_FIELD_PRIVATE, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_FIELDS"), "public static", ConventionKeys.REGEXP_FIELD_PUBLIC_STATIC, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_FIELDS"), "protected static", ConventionKeys.REGEXP_FIELD_PROTECTED_STATIC, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_FIELDS"), "default static", ConventionKeys.REGEXP_FIELD_DEFAULT_STATIC, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_FIELDS"), "private static", ConventionKeys.REGEXP_FIELD_PRIVATE_STATIC, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_FIELDS"), "public static final", ConventionKeys.REGEXP_FIELD_PUBLIC_STATIC_FINAL, "[a-zA-Z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_FIELDS"), "protected static final", ConventionKeys.REGEXP_FIELD_PROTECTED_STATIC_FINAL, "[a-zA-Z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_FIELDS"), "default static final", ConventionKeys.REGEXP_FIELD_DEFAULT_STATIC_FINAL, "[a-zA-Z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_FIELDS"), "private static final", ConventionKeys.REGEXP_FIELD_PRIVATE_STATIC_FINAL, "[a-zA-Z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_METHODS"), "public", ConventionKeys.REGEXP_METHOD_PUBLIC, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_METHODS"), "protected", ConventionKeys.REGEXP_METHOD_PROTECTED, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_METHODS"), "default", ConventionKeys.REGEXP_METHOD_DEFAULT, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_METHODS"), "private", ConventionKeys.REGEXP_METHOD_PRIVATE, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_METHODS"), "public static", ConventionKeys.REGEXP_METHOD_PUBLIC_STATIC, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_METHODS"), "protected static", ConventionKeys.REGEXP_METHOD_PROTECTED_STATIC, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_METHODS"), "default static", ConventionKeys.REGEXP_METHOD_DEFAULT_STATIC, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_METHODS"), "private static", ConventionKeys.REGEXP_METHOD_PRIVATE_STATIC, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_METHODS"), "public static final", ConventionKeys.REGEXP_METHOD_PUBLIC_STATIC_FINAL, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_METHODS"), "protected static final", ConventionKeys.REGEXP_METHOD_PROTECTED_STATIC_FINAL, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_METHODS"), "default static final", ConventionKeys.REGEXP_METHOD_DEFAULT_STATIC_FINAL, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_METHODS"), "private static final", ConventionKeys.REGEXP_METHOD_PRIVATE_STATIC_FINAL, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_PARAMETER"), null, ConventionKeys.REGEXP_PARAM, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_PARAMETER"), "final", ConventionKeys.REGEXP_PARAM_FINAL, "[a-z][\\w]+"), new PatternListEntry(this.bundle.getString("LBL_LOCAL_VARIABLE"), null, ConventionKeys.REGEXP_LOCAL_VARIABLE, "[a-z][\\w]*"), new PatternListEntry(this.bundle.getString("LBL_LABELS"), null, ConventionKeys.REGEXP_LABEL, "\\w+")};
        this._patternList = new JList<PatternListEntry>(entries);
        this._patternList.setFont(new Font("Courier", 0, 11));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        JScrollPane scrollPane = new JScrollPane(this._patternList);
        c.insets.bottom = 10;
        c.insets.top = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 1.0, 18, 1, c.insets, 0, 0);
        layout.setConstraints(scrollPane, c);
        this.add(scrollPane);
        final JButton changeButton = SwingHelper.createButton(this.bundle.getString("BTN_CHANGE"));
        changeButton.setEnabled(false);
        changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Window owner = SwingUtilities.windowForComponent(NamingSettingsPage.this);
                RegexpDialog dialog = NamingSettingsPage.this.create(owner);
                dialog.setVisible(true);
                dialog.dispose();
            }
        });
        c.insets.right = 20;
        c.insets.top = 0;
        c.insets.bottom = 20;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 13, 0, c.insets, 0, 0);
        layout.setConstraints(changeButton, c);
        this.add(changeButton);
        this._patternList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent ev) {
                if (ev.getClickCount() > 1) {
                    Window owner = SwingUtilities.windowForComponent(NamingSettingsPage.this);
                    RegexpDialog dialog = NamingSettingsPage.this.create(owner);
                    dialog.setVisible(true);
                    dialog.dispose();
                }
            }
        });
        this._patternList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                if (ev.getValueIsAdjusting()) {
                    return;
                }
                changeButton.setEnabled(!NamingSettingsPage.this._patternList.isSelectionEmpty());
            }
        });
    }

    private final class RegexpDialog
    extends JDialog {
        JLabel messageLabel;

        RegexpDialog(Frame owner) {
            super(owner);
            this.initialize();
        }

        RegexpDialog(Dialog owner) {
            super(owner);
            this.initialize();
        }

        private void setPattern(String pattern) {
            PatternListEntry entry = (PatternListEntry)NamingSettingsPage.this._patternList.getSelectedValue();
            entry.pattern = pattern;
            NamingSettingsPage.this._patternList.setSelectedValue(entry, false);
        }

        private String getPattern() {
            PatternListEntry entry = (PatternListEntry)NamingSettingsPage.this._patternList.getSelectedValue();
            return entry.pattern;
        }

        private void initialize() {
            this.setTitle(ResourceBundleFactory.getBundle(NamingSettingsPage.BUNDLE_NAME).getString("TLE_REGEXP_TESTER"));
            this.setModal(true);
            this.setDefaultCloseOperation(2);
            Container pane = this.getContentPane();
            GridBagLayout layout = new GridBagLayout();
            pane.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            JLabel patternLabel = new JLabel(ResourceBundleFactory.getBundle(NamingSettingsPage.BUNDLE_NAME).getString("LBL_PATTERN"));
            c.insets.top = 10;
            c.insets.left = 15;
            c.insets.right = 10;
            SwingHelper.setConstraints(c, 0, 0, 1, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
            layout.setConstraints(patternLabel, c);
            pane.add(patternLabel);
            c.insets.left = 0;
            c.insets.right = 15;
            JTextField patternTextField = new JTextField(this.getPattern(), 25);
            SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
            layout.setConstraints(patternTextField, c);
            pane.add(patternTextField);
            JLabel testLabel = new JLabel(ResourceBundleFactory.getBundle(NamingSettingsPage.BUNDLE_NAME).getString("LBL_STRING"));
            c.insets.top = 0;
            c.insets.bottom = 10;
            c.insets.left = 15;
            c.insets.right = 10;
            SwingHelper.setConstraints(c, 0, 1, 1, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
            layout.setConstraints(testLabel, c);
            pane.add(testLabel);
            c.insets.left = 0;
            c.insets.right = 15;
            JTextField testTextField = new JTextField(EMPTY_STRING, 25);
            SwingHelper.setConstraints(c, 1, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
            layout.setConstraints(testTextField, c);
            pane.add(testTextField);
            this.messageLabel = new JLabel(" ");
            this.messageLabel.setFont(new Font("Courier", 1, 14));
            c.insets.top = 15;
            c.insets.bottom = 15;
            c.insets.left = 20;
            c.insets.right = 20;
            SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
            layout.setConstraints(this.messageLabel, c);
            pane.add(this.messageLabel);
            JButton testButton = SwingHelper.createButton(ResourceBundleFactory.getBundle(NamingSettingsPage.BUNDLE_NAME).getString("BTN_TEST"));
            c.insets.top = 0;
            c.insets.bottom = 10;
            c.insets.left = 15;
            c.insets.right = 50;
            SwingHelper.setConstraints(c, 0, 3, 1, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
            layout.setConstraints(testButton, c);
            pane.add(testButton);
            testButton.addActionListener(new ActionListener(this, patternTextField, testTextField){
                private final /* synthetic */ JTextField val$patternTextField;
                private final /* synthetic */ JTextField val$testTextField;
                private final /* synthetic */ RegexpDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$patternTextField = val$patternTextField;
                    this.val$testTextField = val$testTextField;
                }

                public void actionPerformed(ActionEvent ev) {
                    if (!RegexpDialog.access$300(this.this$1, this.val$patternTextField.getText(), this.val$testTextField.getText())) {
                        this.val$testTextField.requestFocus();
                    }
                }
            });
            JButton applyButton = SwingHelper.createButton(ResourceBundleFactory.getBundle(NamingSettingsPage.BUNDLE_NAME).getString("BTN_APPLY"));
            c.insets.left = 10;
            c.insets.right = 5;
            SwingHelper.setConstraints(c, 4, 3, 1, 1, 1.0, 0.0, 13, 0, c.insets, 0, 0);
            layout.setConstraints(applyButton, c);
            pane.add(applyButton);
            applyButton.addActionListener(new ActionListener(this, patternTextField, testTextField){
                private final /* synthetic */ JTextField val$patternTextField;
                private final /* synthetic */ JTextField val$testTextField;
                private final /* synthetic */ RegexpDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$patternTextField = val$patternTextField;
                    this.val$testTextField = val$testTextField;
                }

                public void actionPerformed(ActionEvent ev) {
                    if (RegexpDialog.access$300(this.this$1, this.val$patternTextField.getText(), this.val$testTextField.getText())) {
                        RegexpDialog.access$400(this.this$1, this.val$patternTextField.getText());
                        this.this$1.dispose();
                    }
                }
            });
            JButton cancelButton = SwingHelper.createButton(ResourceBundleFactory.getBundle(NamingSettingsPage.BUNDLE_NAME).getString("BTN_CANCEL"));
            c.insets.left = 0;
            c.insets.right = 15;
            SwingHelper.setConstraints(c, 5, 3, 0, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
            layout.setConstraints(cancelButton, c);
            pane.add(cancelButton);
            cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ RegexpDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ev) {
                    this.this$1.dispose();
                }
            });
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        private boolean test(String pattern, String string) {
            Pattern regexp = null;
            try {
                Perl5Compiler compiler = new Perl5Compiler();
                regexp = compiler.compile(pattern);
            }
            catch (MalformedPatternException ex) {
                this.messageLabel.setForeground(Color.red);
                this.messageLabel.setText(ResourceBundleFactory.getBundle(NamingSettingsPage.BUNDLE_NAME).getString("LBL_INVALID_PATTERN"));
                return false;
            }
            Perl5Matcher matcher = new Perl5Matcher();
            if (matcher.matches(string, regexp)) {
                this.messageLabel.setForeground(Color.blue);
                this.messageLabel.setText(ResourceBundleFactory.getBundle(NamingSettingsPage.BUNDLE_NAME).getString("LBL_PATTERN_MATCHES"));
                return true;
            }
            this.messageLabel.setForeground(Color.red);
            this.messageLabel.setText(ResourceBundleFactory.getBundle(NamingSettingsPage.BUNDLE_NAME).getString("LBL_PATTERN_DOES_NOT_MATCH"));
            return false;
        }

        static /* synthetic */ boolean access$300(RegexpDialog x0, String x1, String x2) {
            return x0.test(x1, x2);
        }

        static /* synthetic */ void access$400(RegexpDialog x0, String x1) {
            x0.setPattern(x1);
        }
    }

    private final class PatternListEntry {
        Convention.Key key;
        String modifiers;
        String name;
        String pattern;

        public PatternListEntry(String name, String modifiers, Convention.Key key, String pattern) {
            this.name = name;
            this.modifiers = modifiers;
            this.key = key;
            this.pattern = NamingSettingsPage.this.settings.get(key, pattern);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(120);
            buf.append(this.name);
            buf.append(' ');
            if (this.modifiers != null) {
                buf.append('<');
                buf.append(this.modifiers);
                buf.append('>');
                buf.append(' ');
            }
            if (buf.length() < 36) {
                int size = 36 - buf.length();
                for (int i = 0; i < size; ++i) {
                    buf.append(' ');
                }
            }
            buf.append(' ');
            buf.append(this.pattern);
            return buf.toString();
        }
    }
}

