#!/usr/bin/env python
# -*- Mode: Python; py-indent-offset: 4 -*-

from string import *
import sys
import os
import re
import exceptions
import errno
import getopt

import defsparser
import message
from argtypes import *

parser = defsparser

class Done (exceptions.Exception):
    def __init__(self):
        pass

def open_object_outfile (obj):    
    outfile = open (code_dir + '/' + lower(obj.name) + '.code', 'w')

    return outfile

def fix_name (name):
    name = upper (name)
    name = replace (name, 'GDK_VISUAL_', '')
    name = replace (name, 'GTK_', '')
    name = replace (name, 'GDK_', '')
    name = replace (name, 'G_', '')
    name = replace (name, '-', '_')
    name = replace (name, '2BUTTON', 'TWO_BUTTON')
    name = replace (name, '3BUTTON', 'THREE_BUTTON')
    return name

def write_enum (enum, file):
    indent = ""

    file.write ("%%% " + enum.c_name + '\n\n')
    file.write ("!!! implementation\n")
    
    file.write (indent + "typedef enum\n")
    file.write (indent + "{\n")

    for (name, cname) in enum.values[:-1]:
        name = fix_name (cname)
        file.write (indent + "  " + name + ' = ' + cname + ",\n")

    ## last one has no comma
    v = enum.values[-1]

    name = fix_name (v[1])
    cname = v[1]

    file.write (indent + "  " + name + ' = ' + cname + "\n")
    
    file.write (indent + "} " + enum.name + ";\n")

    
code_dir = None
script_dir = None
defs_file = None
defs_parser = None

opts, args = getopt.getopt(sys.argv[1:], '', ['code-dir=', 'script-dir=', 'defs='])

for (arg, val) in opts:
    if arg == '--code-dir':
        code_dir = val
    elif arg == '--script-dir':
        script_dir = val
    elif arg == '--defs':
        defs_file = val

if code_dir == None:
    message.die ("must specify destination for the .code files")

if script_dir == None:
    message.die ("must specify scripts dir")

if defs_file == None:
    message.die ("must specify defs file")

try:
    os.mkdir (code_dir)
except OSError, e:
    if e.errno != errno.EEXIST:
        message.die (e)

print "Code directory is: %s" % code_dir

print "Parsing .defs file..."
defs_parser = parser.DefsParser(defs_file)
defs_parser.startParsing()
print "    ... done."

## Register enums and flags with the type registry thing,
## and print out enums for our current module
enum_file = os.path.join(code_dir, 'enums.code')
efile = open (enum_file, 'w')
for e in defs_parser.enums:
    write_enum (e, efile)
    matcher.register_enum (e)

isolated_char = re.compile ('(_[a-z])_')
isolated_char_2 = re.compile ('^([a-z])_')

def studly_to_uscore (str):
    new_str = ''
    for c in str:
        if new_str != '' and c in uppercase:
            new_str = new_str + '_' + lower (c)
        else:
            new_str = new_str + lower (c)

    new_str = isolated_char.sub ('\1', new_str)
    new_str = isolated_char_2.sub ('\1', new_str)

    return new_str

for obj in defs_parser.objects:
    outfile = open_object_outfile (obj)

    methods = defs_parser.find_methods (obj)

    for m in methods:
        try:
            outtext = '\n%%% ' + m.c_name + "\n"

            ret_handler = matcher.get (m.ret)

            if not ret_handler:
                message.warn ("don't know about type `%s'" % m.ret)
                raise Done

            outtext = outtext + ret_handler.get_return(0) + ' ' + m.name

            v = VarList ()
            for (type, name, default, nullok) in m.params:
                handler = matcher.get (type)
                if not handler:
                    message.warn ("don't know about type `%s'" % type)
                    raise Done

                handler.write_in_param (v, name, nullok)

            outtext = outtext + ' (' + v.__str__() + ');\n'

            ### Write the implementation

            outtext = outtext + '\n!!! implementation\n'

            outtext = outtext + ret_handler.get_return(0) + '\n' + \
                      '<QUALIFIER>' + m.name

            outtext = outtext + ' (' + v.__str__() + ')\n'

            outtext = outtext + '{\n'

            call = "  " + ret_handler.get_function_return_marshal(0) + \
                   ' ' + m.c_name + ' ('

            # we need the name of the method to get the GTK
            # object (gtk_adjustment(), gtk_widget())
            objname = studly_to_uscore (m.of_object[0])
            module = lower (m.of_object[1])
            prefix = join([module, objname], '_')

            call = call + prefix + ' (), '

            for (type, name, default, nullok) in m.params:
                handler = matcher.get (type)
                if not handler:
                    message.warn ("don't know about type `%s'" % type)
                    raise Done

                call = call + handler.get_arg (name, 0)
                call = call + ', '

            # chop last ', '
            call = call[:-2] + ');\n'

            outtext = outtext + call
            
            outtext = outtext + '}\n'                

            ### If we didn't inline, the function definition
            ### would go here.

            ## write to file only once we have all the stuff,
            ## in case we fail halfway through
            outfile.write (outtext + "\n")

        except Done:
            pass


