// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_SLOT_H_
#define _INTI_BASE_SLOT_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*$ doc header
  $short Slot objects (callable objects you can connect to signals, etc.)
  $*/

namespace Inti
{  
  class Slot
  {
  public:
    
    void ref ()
    {
      ref_count_ += 1;
    }
    
    void unref ();

    void sink ();
    
  protected:
    Slot ()
      : ref_count_(1), floating_(true)
    {
    }

    virtual ~Slot () = 0;
    
  private:
    unsigned int ref_count_;
    bool floating_;

    // not copyable
    Slot (const Slot&);
    Slot& operator=(const Slot&);
  }; // class Slot
  
  /////////////////////////////////////////////////////////////////
  

  // Abstract base class for slots with 0 argument(s)
  template <class ReturnType>
  class Slot0 : public Slot
  {
  protected:
    Slot0 ()
    {
    }
  public:
    virtual ReturnType invoke () const = 0;

    ReturnType operator() () const
    {
      return invoke ();
    }
  };

  // Concrete class for slots created from methods with 0 argument(s)
  template <class MethodClassType, class ReturnType>
  class MethodSlot0 : public Slot0<ReturnType>
  {
  private:
    typedef ReturnType (MethodClassType::* MethodType) ();
  public:
    MethodSlot0 (MethodClassType *object,
                 MethodType method)
      : obj_(object), method_(method)
    {
    }
    virtual ReturnType invoke () const
    {
      return (obj_->*method_) ();
    }
  protected:
    virtual ~MethodSlot0 ()
    {
    }
  private:
    MethodClassType *obj_;
    MethodType method_;
  }; // class MethodSlot0

  // Concrete class for slots created from static functions with 0 argument(s)
  template <class ReturnType>
  class FunctionSlot0 : public Slot0<ReturnType>
  {
  private:
    typedef ReturnType (* FunctionType) ();
  public:
    FunctionSlot0 (FunctionType function)
      : function_(function)
    {
    }
    virtual ReturnType invoke () const
    {
      return (* function_) ();
    }
  protected:
    virtual ~FunctionSlot0 ()
    {
    }
  private:
    FunctionType function_;
  }; // class FunctionSlot0

  // convenience function that creates a MethodSlot
  template <class MethodClassType, class ReturnType>
  inline Slot0<ReturnType> *
  slot (MethodClassType *obj, ReturnType (MethodClassType::* method) ())
  {
    return new MethodSlot0<MethodClassType, ReturnType> (obj, method);
  }

  // convenience function that creates a FunctionSlot
  template <class ReturnType>
  inline Slot0<ReturnType> *
  slot (ReturnType (* function) ())
  {
    return new FunctionSlot0<ReturnType> (function);
  }

  // Abstract base class for slots with 1 argument(s)
  template <class ReturnType, class Arg1Type>
  class Slot1 : public Slot
  {
  protected:
    Slot1 ()
    {
    }
  public:
    virtual ReturnType invoke (Arg1Type arg1) const = 0;

    ReturnType operator() (Arg1Type arg1) const
    {
      return invoke (arg1);
    }
  };

  // Concrete class for slots created from methods with 1 argument(s)
  template <class MethodClassType, class ReturnType, class Arg1Type>
  class MethodSlot1 : public Slot1<ReturnType, Arg1Type>
  {
  private:
    typedef ReturnType (MethodClassType::* MethodType) (Arg1Type);
  public:
    MethodSlot1 (MethodClassType *object,
                 MethodType method)
      : obj_(object), method_(method)
    {
    }
    virtual ReturnType invoke (Arg1Type arg1) const
    {
      return (obj_->*method_) (arg1);
    }
  protected:
    virtual ~MethodSlot1 ()
    {
    }
  private:
    MethodClassType *obj_;
    MethodType method_;
  }; // class MethodSlot1

  // Concrete class for slots created from static functions with 1 argument(s)
  template <class ReturnType, class Arg1Type>
  class FunctionSlot1 : public Slot1<ReturnType, Arg1Type>
  {
  private:
    typedef ReturnType (* FunctionType) (Arg1Type);
  public:
    FunctionSlot1 (FunctionType function)
      : function_(function)
    {
    }
    virtual ReturnType invoke (Arg1Type arg1) const
    {
      return (* function_) (arg1);
    }
  protected:
    virtual ~FunctionSlot1 ()
    {
    }
  private:
    FunctionType function_;
  }; // class FunctionSlot1

  // convenience function that creates a MethodSlot
  template <class MethodClassType, class ReturnType, class Arg1Type>
  inline Slot1<ReturnType, Arg1Type> *
  slot (MethodClassType *obj, ReturnType (MethodClassType::* method) (Arg1Type))
  {
    return new MethodSlot1<MethodClassType, ReturnType, Arg1Type> (obj, method);
  }

  // convenience function that creates a FunctionSlot
  template <class ReturnType, class Arg1Type>
  inline Slot1<ReturnType, Arg1Type> *
  slot (ReturnType (* function) (Arg1Type))
  {
    return new FunctionSlot1<ReturnType, Arg1Type> (function);
  }

  // Abstract base class for slots with 2 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type>
  class Slot2 : public Slot
  {
  protected:
    Slot2 ()
    {
    }
  public:
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2) const = 0;

    ReturnType operator() (Arg1Type arg1, Arg2Type arg2) const
    {
      return invoke (arg1, arg2);
    }
  };

  // Concrete class for slots created from methods with 2 argument(s)
  template <class MethodClassType, class ReturnType, class Arg1Type, class Arg2Type>
  class MethodSlot2 : public Slot2<ReturnType, Arg1Type, Arg2Type>
  {
  private:
    typedef ReturnType (MethodClassType::* MethodType) (Arg1Type, Arg2Type);
  public:
    MethodSlot2 (MethodClassType *object,
                 MethodType method)
      : obj_(object), method_(method)
    {
    }
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2) const
    {
      return (obj_->*method_) (arg1, arg2);
    }
  protected:
    virtual ~MethodSlot2 ()
    {
    }
  private:
    MethodClassType *obj_;
    MethodType method_;
  }; // class MethodSlot2

  // Concrete class for slots created from static functions with 2 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type>
  class FunctionSlot2 : public Slot2<ReturnType, Arg1Type, Arg2Type>
  {
  private:
    typedef ReturnType (* FunctionType) (Arg1Type, Arg2Type);
  public:
    FunctionSlot2 (FunctionType function)
      : function_(function)
    {
    }
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2) const
    {
      return (* function_) (arg1, arg2);
    }
  protected:
    virtual ~FunctionSlot2 ()
    {
    }
  private:
    FunctionType function_;
  }; // class FunctionSlot2

  // convenience function that creates a MethodSlot
  template <class MethodClassType, class ReturnType, class Arg1Type, class Arg2Type>
  inline Slot2<ReturnType, Arg1Type, Arg2Type> *
  slot (MethodClassType *obj, ReturnType (MethodClassType::* method) (Arg1Type, Arg2Type))
  {
    return new MethodSlot2<MethodClassType, ReturnType, Arg1Type, Arg2Type> (obj, method);
  }

  // convenience function that creates a FunctionSlot
  template <class ReturnType, class Arg1Type, class Arg2Type>
  inline Slot2<ReturnType, Arg1Type, Arg2Type> *
  slot (ReturnType (* function) (Arg1Type, Arg2Type))
  {
    return new FunctionSlot2<ReturnType, Arg1Type, Arg2Type> (function);
  }

  // Abstract base class for slots with 3 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type>
  class Slot3 : public Slot
  {
  protected:
    Slot3 ()
    {
    }
  public:
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3) const = 0;

    ReturnType operator() (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3) const
    {
      return invoke (arg1, arg2, arg3);
    }
  };

  // Concrete class for slots created from methods with 3 argument(s)
  template <class MethodClassType, class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type>
  class MethodSlot3 : public Slot3<ReturnType, Arg1Type, Arg2Type, Arg3Type>
  {
  private:
    typedef ReturnType (MethodClassType::* MethodType) (Arg1Type, Arg2Type, Arg3Type);
  public:
    MethodSlot3 (MethodClassType *object,
                 MethodType method)
      : obj_(object), method_(method)
    {
    }
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3) const
    {
      return (obj_->*method_) (arg1, arg2, arg3);
    }
  protected:
    virtual ~MethodSlot3 ()
    {
    }
  private:
    MethodClassType *obj_;
    MethodType method_;
  }; // class MethodSlot3

  // Concrete class for slots created from static functions with 3 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type>
  class FunctionSlot3 : public Slot3<ReturnType, Arg1Type, Arg2Type, Arg3Type>
  {
  private:
    typedef ReturnType (* FunctionType) (Arg1Type, Arg2Type, Arg3Type);
  public:
    FunctionSlot3 (FunctionType function)
      : function_(function)
    {
    }
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3) const
    {
      return (* function_) (arg1, arg2, arg3);
    }
  protected:
    virtual ~FunctionSlot3 ()
    {
    }
  private:
    FunctionType function_;
  }; // class FunctionSlot3

  // convenience function that creates a MethodSlot
  template <class MethodClassType, class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type>
  inline Slot3<ReturnType, Arg1Type, Arg2Type, Arg3Type> *
  slot (MethodClassType *obj, ReturnType (MethodClassType::* method) (Arg1Type, Arg2Type, Arg3Type))
  {
    return new MethodSlot3<MethodClassType, ReturnType, Arg1Type, Arg2Type, Arg3Type> (obj, method);
  }

  // convenience function that creates a FunctionSlot
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type>
  inline Slot3<ReturnType, Arg1Type, Arg2Type, Arg3Type> *
  slot (ReturnType (* function) (Arg1Type, Arg2Type, Arg3Type))
  {
    return new FunctionSlot3<ReturnType, Arg1Type, Arg2Type, Arg3Type> (function);
  }

  // Abstract base class for slots with 4 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type>
  class Slot4 : public Slot
  {
  protected:
    Slot4 ()
    {
    }
  public:
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4) const = 0;

    ReturnType operator() (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4) const
    {
      return invoke (arg1, arg2, arg3, arg4);
    }
  };

  // Concrete class for slots created from methods with 4 argument(s)
  template <class MethodClassType, class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type>
  class MethodSlot4 : public Slot4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type>
  {
  private:
    typedef ReturnType (MethodClassType::* MethodType) (Arg1Type, Arg2Type, Arg3Type, Arg4Type);
  public:
    MethodSlot4 (MethodClassType *object,
                 MethodType method)
      : obj_(object), method_(method)
    {
    }
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4) const
    {
      return (obj_->*method_) (arg1, arg2, arg3, arg4);
    }
  protected:
    virtual ~MethodSlot4 ()
    {
    }
  private:
    MethodClassType *obj_;
    MethodType method_;
  }; // class MethodSlot4

  // Concrete class for slots created from static functions with 4 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type>
  class FunctionSlot4 : public Slot4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type>
  {
  private:
    typedef ReturnType (* FunctionType) (Arg1Type, Arg2Type, Arg3Type, Arg4Type);
  public:
    FunctionSlot4 (FunctionType function)
      : function_(function)
    {
    }
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4) const
    {
      return (* function_) (arg1, arg2, arg3, arg4);
    }
  protected:
    virtual ~FunctionSlot4 ()
    {
    }
  private:
    FunctionType function_;
  }; // class FunctionSlot4

  // convenience function that creates a MethodSlot
  template <class MethodClassType, class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type>
  inline Slot4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type> *
  slot (MethodClassType *obj, ReturnType (MethodClassType::* method) (Arg1Type, Arg2Type, Arg3Type, Arg4Type))
  {
    return new MethodSlot4<MethodClassType, ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type> (obj, method);
  }

  // convenience function that creates a FunctionSlot
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type>
  inline Slot4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type> *
  slot (ReturnType (* function) (Arg1Type, Arg2Type, Arg3Type, Arg4Type))
  {
    return new FunctionSlot4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type> (function);
  }

  // Abstract base class for slots with 5 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type>
  class Slot5 : public Slot
  {
  protected:
    Slot5 ()
    {
    }
  public:
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5) const = 0;

    ReturnType operator() (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5) const
    {
      return invoke (arg1, arg2, arg3, arg4, arg5);
    }
  };

  // Concrete class for slots created from methods with 5 argument(s)
  template <class MethodClassType, class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type>
  class MethodSlot5 : public Slot5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type>
  {
  private:
    typedef ReturnType (MethodClassType::* MethodType) (Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type);
  public:
    MethodSlot5 (MethodClassType *object,
                 MethodType method)
      : obj_(object), method_(method)
    {
    }
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5) const
    {
      return (obj_->*method_) (arg1, arg2, arg3, arg4, arg5);
    }
  protected:
    virtual ~MethodSlot5 ()
    {
    }
  private:
    MethodClassType *obj_;
    MethodType method_;
  }; // class MethodSlot5

  // Concrete class for slots created from static functions with 5 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type>
  class FunctionSlot5 : public Slot5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type>
  {
  private:
    typedef ReturnType (* FunctionType) (Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type);
  public:
    FunctionSlot5 (FunctionType function)
      : function_(function)
    {
    }
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5) const
    {
      return (* function_) (arg1, arg2, arg3, arg4, arg5);
    }
  protected:
    virtual ~FunctionSlot5 ()
    {
    }
  private:
    FunctionType function_;
  }; // class FunctionSlot5

  // convenience function that creates a MethodSlot
  template <class MethodClassType, class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type>
  inline Slot5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type> *
  slot (MethodClassType *obj, ReturnType (MethodClassType::* method) (Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type))
  {
    return new MethodSlot5<MethodClassType, ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type> (obj, method);
  }

  // convenience function that creates a FunctionSlot
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type>
  inline Slot5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type> *
  slot (ReturnType (* function) (Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type))
  {
    return new FunctionSlot5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type> (function);
  }

  // Abstract base class for slots with 6 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Arg6Type>
  class Slot6 : public Slot
  {
  protected:
    Slot6 ()
    {
    }
  public:
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5, Arg6Type arg6) const = 0;

    ReturnType operator() (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5, Arg6Type arg6) const
    {
      return invoke (arg1, arg2, arg3, arg4, arg5, arg6);
    }
  };

  // Concrete class for slots created from methods with 6 argument(s)
  template <class MethodClassType, class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Arg6Type>
  class MethodSlot6 : public Slot6<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type>
  {
  private:
    typedef ReturnType (MethodClassType::* MethodType) (Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type);
  public:
    MethodSlot6 (MethodClassType *object,
                 MethodType method)
      : obj_(object), method_(method)
    {
    }
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5, Arg6Type arg6) const
    {
      return (obj_->*method_) (arg1, arg2, arg3, arg4, arg5, arg6);
    }
  protected:
    virtual ~MethodSlot6 ()
    {
    }
  private:
    MethodClassType *obj_;
    MethodType method_;
  }; // class MethodSlot6

  // Concrete class for slots created from static functions with 6 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Arg6Type>
  class FunctionSlot6 : public Slot6<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type>
  {
  private:
    typedef ReturnType (* FunctionType) (Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type);
  public:
    FunctionSlot6 (FunctionType function)
      : function_(function)
    {
    }
    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5, Arg6Type arg6) const
    {
      return (* function_) (arg1, arg2, arg3, arg4, arg5, arg6);
    }
  protected:
    virtual ~FunctionSlot6 ()
    {
    }
  private:
    FunctionType function_;
  }; // class FunctionSlot6

  // convenience function that creates a MethodSlot
  template <class MethodClassType, class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Arg6Type>
  inline Slot6<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type> *
  slot (MethodClassType *obj, ReturnType (MethodClassType::* method) (Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type))
  {
    return new MethodSlot6<MethodClassType, ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type> (obj, method);
  }

  // convenience function that creates a FunctionSlot
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Arg6Type>
  inline Slot6<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type> *
  slot (ReturnType (* function) (Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type))
  {
    return new FunctionSlot6<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type> (function);
  }
  
}; // namespace Inti

#endif // _INTI_BASE_SLOT_H_
