// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "object.h"
#include "object-class.h"
#include <inti/private-util.h>
#include <vector>

void
Inti::Private::object_destroy_notify (void * data)
{
  Inti::Object *obj = (Inti::Object*)data;

  delete obj;
}

Inti::Object::Object ()
  : object_ (0)
{
  init_from_g_object (Private::ObjectClass::make_proxy (),
                      Private::ObjectClass::original_class ());
}

Inti::Object::Object (GObject *obj, GObjectClass * orig)
  : object_ (0)
{
  if (obj)
    init_from_g_object (obj, orig);
}

void
Inti::Object::init_from_g_object (GObject * obj,
                                  GObjectClass * orig)
{
  g_return_if_fail (object_ == 0);
  g_return_if_fail (obj != 0);
  g_return_if_fail (orig != 0);

  object_ = obj;
  original_class_ = orig;


  /////////////// FIXME!
  
  //  if (!GTK_OBJECT_CONSTRUCTED (object_))
  //    gtk_object_default_construct (object_);
  
  g_object_set_qdata_full (object_, Inti::Private::quark (),
                           (void*)this,
                           Inti::Private::object_destroy_notify);

}

static GQuark listeners_quark = 0;

Inti::Object::~Object ()
{
  if (object_ == 0)
    g_warning ("Bug: proxy object never attached to a GObject");
  
  if (object_->ref_count != 0)
    {
      g_warning ("Destructor called for object with reference count greater than 0. You may have called delete yourself; this is not allowed. You may only call unref().");

      // Try to safely recover anyway, just for fun.
      if (listeners_quark != 0)
        g_object_set_qdata (g_object (),
                            listeners_quark,
                            NULL);

      g_object_steal_qdata (object_, Inti::Private::quark ());
    }
}

namespace Inti
{
  struct ListenerData
  {
    vector<DestroyListener*> listeners;
    DestroyNotifier * notifier;
  };

  static void
  listener_data_destroy_notify (gpointer data)
  {
    ListenerData * ld = static_cast<ListenerData*>(data);

    vector<DestroyListener*>::iterator i = ld->listeners.begin ();
    while (i != ld->listeners.end ())
      {
        (*i)->notifier_destroyed (ld->notifier);

        ++i;
      }

    delete ld;
  }

}; // namespace Inti

void
Inti::Object::add_destroy_listener (DestroyListener * listener)
{
  if (listeners_quark == 0)
    {
      listeners_quark = g_quark_from_static_string ("__listener_list");
    }

  ListenerData * ld =
    (ListenerData *) g_object_get_qdata (g_object (),
                                         listeners_quark);
  if (ld == 0)
    {
      ld = new ListenerData;
      ld->notifier = this;

      g_object_set_qdata_full (g_object (),
                               listeners_quark,
                               (void*) ld,
                               listener_data_destroy_notify);
    }

  ld->listeners.push_back (listener);
}

void
Inti::Object::remove_destroy_listener (DestroyListener * listener)
{
  if (listeners_quark == 0)
    return;

  ListenerData * ld =
    (ListenerData *) g_object_get_qdata (g_object (),
                                         listeners_quark);
  if (ld == 0)
    return;

  vector<DestroyListener*>::iterator i = ld->listeners.begin ();
  while (i != ld->listeners.end ())
    {
      if (*i == listener)
        {
          ld->listeners.erase (i);

          if (ld->listeners.empty ())
            {
              g_object_steal_qdata (g_object (),
                                    listeners_quark);

              delete ld;
            }

          return;
        }

      ++i;
    }
}

static GQuark emitter_quark = 0;

void
Inti::Object::add_signal_connection (Inti::Private::NativeConnectionImpl * impl)
{
  if (emitter_quark == 0)
    emitter_quark = g_quark_from_static_string ("__inti_emitter_quark");

  ConnectionList * list = (ConnectionList*)
    g_object_get_qdata (object_,
                        emitter_quark);

  if (list == 0)
    {
      list = new ConnectionList;

      g_object_set_qdata_full (object_, emitter_quark,
                               (void*)list,
                               (GDestroyNotify)free_connection_list);
    }

  add_to_connection_list (list, impl);
}

void
Inti::Object::get_signal_connections (const Signal * signal,
                                         ConnectionList * connections)
{
  if (emitter_quark == 0)
    emitter_quark = g_quark_from_static_string ("__inti_emitter_quark");

  ConnectionList * list =  (ConnectionList*)
    g_object_get_qdata (object_,
                        emitter_quark);

  if (list != 0)
    get_from_connection_list (list, signal, connections);
}

void
Inti::Object::remove_signal_connection (Inti::Private::NativeConnectionImpl * impl)
{
  if (emitter_quark == 0)
    emitter_quark = g_quark_from_static_string ("__inti_emitter_quark");

  ConnectionList * list = (ConnectionList*)
    g_object_get_qdata (object_,
                        emitter_quark);

  if (list != 0)
    {
      remove_from_connnection_list (list, impl);
      if (list->empty ())
        g_object_set_qdata (object_, emitter_quark, NULL); // calls dnotify
    }
}

void
Inti::Object::disconnect_native_connections ()
{
  if (emitter_quark != 0)
    g_object_set_qdata (object_, emitter_quark, NULL); // calls dnotify
}

static GQuark sunk_quark_ = 0;

void
Inti::Object::sink_impl ()
{
  // We use object data for the base class, but not
  // for GtkObject
  if (sunk_quark_ == 0)
    {
      sunk_quark_ = g_quark_from_static_string ("__inti_sunk_quark");
    }

  gpointer sunk = g_object_get_qdata (object_, sunk_quark_);

  if (!sunk)
    {
      g_object_set_qdata (object_, sunk_quark_, GINT_TO_POINTER (1));
      
      unref ();
    }
}

bool
Inti::Object::floating () const
{
  if (sunk_quark_ == 0)
    {
      sunk_quark_ = g_quark_from_static_string ("__inti_sunk_quark");
    }

  gpointer sunk = g_object_get_qdata (object_, sunk_quark_);

  return !sunk;
}

void
Inti::Object::sink ()
{
  sink_impl ();
}

void
Inti::Object::unref ()
{
  if (floating () && 
      object_->ref_count == 1)
    {
      g_warning ("Calling unref() on an object that has only a floating reference count. This means that you did not own a reference to the object; to obtain a reference, you must call ref(). No one owns the floating reference count. Perhaps you meant to call sink().");
    }
  
  g_object_unref (object_);
}

void
Inti::Object::set_data (const string & key, void *data,
                        void (* destroy_notify) (void*))
{
  g_object_set_qdata_full (g_object(), g_quark_from_string (key.c_str()),
                           data, destroy_notify);
}

void
Inti::Object::set_data (const char * key, void *data,
                           void (* destroy_notify) (void*))
{
  g_object_set_qdata_full (g_object(), g_quark_from_string (key),
                           data, destroy_notify);
}

void *
Inti::Object::get_data (const string & key) const
{
  return g_object_get_qdata (g_object(), g_quark_try_string (key.c_str()));
}

void *
Inti::Object::get_data (const char * key) const
{
  return g_object_get_qdata (g_object(), g_quark_try_string (key));
}

void
Inti::Object::remove_data (const string & key, bool notify)
{
  if (notify)
    g_object_set_qdata (g_object(), g_quark_try_string (key.c_str()), NULL);
  else
    g_object_steal_qdata (g_object(), g_quark_try_string (key.c_str()));
}

void
Inti::Object::remove_data (const char * key, bool notify)
{
  if (notify)
    g_object_set_qdata (g_object(), g_quark_try_string (key), NULL);
  else
    g_object_steal_qdata (g_object(), g_quark_try_string (key));
}

#include <map>

namespace Inti
{
  namespace Private
  {
    typedef Object * (* WrapFunc) (GObject*);
    map<string,WrapFunc> wrap_funcs_;
    
    Object * wrap_onelevel (GObject * obj, GType t);
  } // namespace Private
} // namespace Inti

Inti::Object *
Inti::Private::wrap_onelevel (GObject * obj, GType t)
{
  const char * name = g_type_name (t);

  map<string,WrapFunc>::iterator i = wrap_funcs_.find (name);

  if (i != wrap_funcs_.end ())
    {
      WrapFunc func = i->second;

      return (* func) (obj);
    }
  else
    return 0;
}

void
Inti::Object::register_wrapper (const char * orig_type_name,
                                   Object * (* get_wrapper_func) (GObject*))
{
  // replacing an existing wrapper function is permitted.
  Private::wrap_funcs_[orig_type_name] = get_wrapper_func;
}

Inti::Object *
Inti::Object::wrap (GObject * obj)
{
  using namespace Private;

  if (obj == 0)
    return 0;

  gpointer existing = g_object_get_qdata (obj, Inti::Private::quark ());
  if (existing)
    return static_cast<Object*>(existing);
  
  // Create the most-derived wrapper type we know about.

  GType t = G_OBJECT_TYPE (obj);

  while (t != G_TYPE_OBJECT)
    {
      Object * o = wrap_onelevel (obj, t);

      if (o != 0)
        return o;
      else
        t = G_TYPE_FROM_CLASS (g_type_class_peek_parent (G_OBJECT_GET_CLASS (obj)));
    }

  // If it all failed, just create a GObject wrapper (ObjectClass::get_wrapper()
  // isn't in the map of functions because there's no init() call for the base
  // library)
  
  return ObjectClass::get_wrapper (obj);
}

Inti::Object *
Inti::Object::_private_wrap (GObject * obj, bool is_floating)
{
  Object * o;

  o = wrap (obj);

  if (o != 0)
    {
      if (!is_floating)
        {
          if (o->floating ())
            {
              o->ref ();
              o->sink ();
            }
        }
      else
        g_assert_not_reached (); // not implemented because I haven't found a use
    }
  
  return o;
}
  

/////////// Everything below here is machine-generated
