// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_SEPARATOR_H_
#define _INTI_GTK_SEPARATOR_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/widget.h>
#include <gtk/gtkhseparator.h>
#include <gtk/gtkvseparator.h>

/*$ doc header
  $short The #Inti::Gtk::Separator widget
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class SeparatorClass;
      class HSeparatorClass;
      class VSeparatorClass;
    };
    
    class Separator : public Widget
    {
    public:
      /*$ doc class Separator
        $short a separator line abstract base for #HSeparator and #VSeparator

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkSeparator * gtk_separator () const
      {
        return (GtkSeparator*)g_object ();
      }
      
      /*$ doc constructor
        $short Construct a new separator
        $long

        <para>

        </para>
        
        $*/
      Separator ();
      
    protected:
      friend class Private::SeparatorClass;
      
      explicit Separator (GtkSeparator *src, GtkSeparatorClass* orig);
      virtual ~Separator () = 0; // abstract base class
      
    private:
      Separator(const Separator&);
      Separator& operator=(const Separator&);
      
    }; // class Separator

    class HSeparator : public Separator
    {
    public:
      /*$ doc class HSeparator
        $short a horizontal separator line 

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkHSeparator * gtk_hseparator () const
      {
        return (GtkHSeparator*)g_object ();
      }
      
      /*$ doc constructor
        $short Construct a new separator
        $long

        <para>

        </para>
        
        $*/
      HSeparator ();
      
    protected:
      friend class Private::HSeparatorClass;
      
      explicit HSeparator (GtkHSeparator *src, GtkHSeparatorClass* orig);
      virtual ~HSeparator ();
      
    private:
      HSeparator(const HSeparator&);
      HSeparator& operator=(const HSeparator&);
      
    }; // class HSeparator


    class VSeparator : public Separator
    {
    public:
      /*$ doc class VSeparator
        $short a vertical separator line 

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkVSeparator * gtk_hseparator () const
      {
        return (GtkVSeparator*)g_object ();
      }
      
      /*$ doc constructor
        $short Construct a new separator
        $long

        <para>

        </para>
        
        $*/
      VSeparator ();
      
    protected:
      friend class Private::VSeparatorClass;
      
      explicit VSeparator (GtkVSeparator *src, GtkVSeparatorClass* orig);
      virtual ~VSeparator ();
      
    private:
      VSeparator(const VSeparator&);
      VSeparator& operator=(const VSeparator&);
      
    }; // class VSeparator
    
  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_SEPARATOR_H_
