// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_RANGE_H_
#define _INTI_GTK_RANGE_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/widget.h>
#include <gtk/gtkrange.h>
#include <string>

/*$ doc header
  $short The #Inti::Gtk::Range widget, base class for slider widgets
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class RangeClass;
    };

    class Adjustment;
    
    class Range : public Widget
    {
    public:
      /*$ doc class Range
        $short abstract base class for #Scale and #Scrollbar

        $copy none
        $memory floating
        
        $long

        <para>

        </para>

        <para>

        </para>
        
        $*/
        
      GtkRange * gtk_range () const
      {
        return (GtkRange*)g_object ();
      }

      Adjustment * adjustment () const;
      void set_update_policy (Gtk::UpdateType policy);
      void set_adjustment (Inti::Gtk::Adjustment* adjustment);
      UpdateType update_policy () const
      {
        return (UpdateType) gtk_range ()->policy;
      }
      
    protected:
      friend class Private::RangeClass;

      Range ();
      Range (Adjustment * adj);
      explicit Range (GtkRange *src, GtkRangeClass* orig);
      virtual ~Range () = 0; // abstract
      
    private:
      Range(const Range&);
      Range& operator=(const Range&);
      
    }; // class Range

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_RANGE_H_
