// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_GTKBASE_H_
#define _INTI_GTK_GTKBASE_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtktypeutils.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkenums.h>
#include <gtk/gtkpacker.h>
#include <string>

namespace Inti
{  
  namespace Gtk
  {    
    bool init (int *argc, char ***argv, bool fatal_errors=true);


    //////////////////////////////////////// Enumerations
    typedef enum
    {
      ANCHOR_CENTER = GTK_ANCHOR_CENTER,
      ANCHOR_NORTH = GTK_ANCHOR_NORTH,
      ANCHOR_NORTH_WEST = GTK_ANCHOR_NORTH_WEST,
      ANCHOR_NORTH_EAST = GTK_ANCHOR_NORTH_EAST,
      ANCHOR_SOUTH = GTK_ANCHOR_SOUTH,
      ANCHOR_SOUTH_WEST = GTK_ANCHOR_SOUTH_WEST,
      ANCHOR_SOUTH_EAST = GTK_ANCHOR_SOUTH_EAST,
      ANCHOR_WEST = GTK_ANCHOR_WEST,
      ANCHOR_EAST = GTK_ANCHOR_EAST,
      ANCHOR_N = GTK_ANCHOR_N,
      ANCHOR_NW = GTK_ANCHOR_NW,
      ANCHOR_NE = GTK_ANCHOR_NE,
      ANCHOR_S = GTK_ANCHOR_S,
      ANCHOR_SW = GTK_ANCHOR_SW,
      ANCHOR_SE = GTK_ANCHOR_SE,
      ANCHOR_W = GTK_ANCHOR_W,
      ANCHOR_E = GTK_ANCHOR_E
    } AnchorType;
    typedef enum
    {
      STATE_NORMAL = GTK_STATE_NORMAL,
      STATE_ACTIVE = GTK_STATE_ACTIVE,
      STATE_PRELIGHT = GTK_STATE_PRELIGHT,
      STATE_SELECTED = GTK_STATE_SELECTED,
      STATE_INSENSITIVE = GTK_STATE_INSENSITIVE
    } StateType;
    typedef enum
    {
      DIR_TAB_FORWARD = GTK_DIR_TAB_FORWARD,
      DIR_TAB_BACKWARD = GTK_DIR_TAB_BACKWARD,
      DIR_UP = GTK_DIR_UP,
      DIR_DOWN = GTK_DIR_DOWN,
      DIR_LEFT = GTK_DIR_LEFT,
      DIR_RIGHT = GTK_DIR_RIGHT
    } DirectionType;
    typedef enum
    {
      JUSTIFY_LEFT = GTK_JUSTIFY_LEFT,
      JUSTIFY_RIGHT = GTK_JUSTIFY_RIGHT,
      JUSTIFY_CENTER = GTK_JUSTIFY_CENTER,
      JUSTIFY_FILL = GTK_JUSTIFY_FILL
    } Justification;
    typedef enum
    {
      RELIEF_NORMAL = GTK_RELIEF_NORMAL,
      RELIEF_HALF = GTK_RELIEF_HALF,
      RELIEF_NONE = GTK_RELIEF_NONE
    } ReliefStyle;
    typedef enum
    {
      EXPAND = GTK_EXPAND,
      SHRINK = GTK_SHRINK,
      FILL = GTK_FILL
    } AttachOptions;
    typedef unsigned int AttachOptionsField;
    typedef enum
    {
      POLICY_ALWAYS = GTK_POLICY_ALWAYS,
      POLICY_AUTOMATIC = GTK_POLICY_AUTOMATIC,
      POLICY_NEVER = GTK_POLICY_NEVER
    } PolicyType;
    typedef enum
    {
      CORNER_TOP_LEFT = GTK_CORNER_TOP_LEFT,
      CORNER_BOTTOM_LEFT = GTK_CORNER_BOTTOM_LEFT,
      CORNER_TOP_RIGHT = GTK_CORNER_TOP_RIGHT,
      CORNER_BOTTOM_RIGHT = GTK_CORNER_BOTTOM_RIGHT
    } CornerType;
    typedef enum
    {
      UPDATE_CONTINUOUS = GTK_UPDATE_CONTINUOUS,
      UPDATE_DISCONTINUOUS = GTK_UPDATE_DISCONTINUOUS,
      UPDATE_DELAYED = GTK_UPDATE_DELAYED
    } UpdateType;
    typedef enum
    {
      POS_LEFT = GTK_POS_LEFT,
      POS_RIGHT = GTK_POS_RIGHT,
      POS_TOP = GTK_POS_TOP,
      POS_BOTTOM = GTK_POS_BOTTOM
    } PositionType;
    typedef enum
    {
      SHADOW_NONE = GTK_SHADOW_NONE,
      SHADOW_IN = GTK_SHADOW_IN,
      SHADOW_OUT = GTK_SHADOW_OUT,
      SHADOW_ETCHED_IN = GTK_SHADOW_ETCHED_IN,
      SHADOW_ETCHED_OUT = GTK_SHADOW_ETCHED_OUT
    } ShadowType;
    typedef enum
    {
      ARROW_UP = GTK_ARROW_UP,
      ARROW_DOWN = GTK_ARROW_DOWN,
      ARROW_LEFT = GTK_ARROW_LEFT,
      ARROW_RIGHT = GTK_ARROW_RIGHT
    } ArrowType;
    typedef enum
    {
      ORIENTATION_HORIZONTAL = GTK_ORIENTATION_HORIZONTAL,
      ORIENTATION_VERTICAL = GTK_ORIENTATION_VERTICAL
    } Orientation;
    
    ///// FIXME gtk_set_locale, and i18n in general

    
    
  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_GTKBASE_H_
