// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "entry.h"
#include "entry-class.h"
#include "marshal.h"
#include <inti/proxies.h>
#include <inti/private-util.h>

/////////// Object

Inti::Gtk::Entry::Entry ()
  : Widget ((GtkWidget*)Private::EntryClass::make_proxy(),
            (GtkWidgetClass*)Private::EntryClass::original_class())
{
  
}

Inti::Gtk::Entry::Entry (GtkEntry *obj,
                         GtkEntryClass *orig)
  : Widget ((GtkWidget*)obj,
            (GtkWidgetClass*)orig)
{
  
}

Inti::Gtk::Entry::~Entry ()
{

}


Inti::ustring
Inti::Gtk::Entry::text () const
{
  // Use deprecated function to avoid gratuitous strdup()/free()
  return ustring (gtk_entry_get_text (gtk_entry ()));
}
      
int
Inti::Gtk::Entry::max_length () const
{
  return gtk_entry ()->text_max_length;
}

bool
Inti::Gtk::Entry::visibility () const
{
  return gtk_entry ()->visible;
}

gunichar
Inti::Gtk::Entry::invisible_char () const
{
  return gtk_entry ()->invisible_char;
}

void
Inti::Gtk::Entry::insert_text (const ustring & text, int * position)
{
  gtk_editable_insert_text (gtk_editable (),
                            text.c_str (),
                            text.str ().size (),
                            position);
}

void
Inti::Gtk::Entry::insert_text (const char * text, int * position)
{
  gtk_editable_insert_text (gtk_editable (),
                            text,
                            -1,
                            position);
}

Inti::ustring
Inti::Gtk::Entry::get_chars (int start_pos, int end_pos)
{
  gchar * s = gtk_editable_get_chars (gtk_editable (), start_pos, end_pos);

  ustring retval (s);

  g_free (s);

  return retval;
}

int
Inti::Gtk::Entry::position () const
{
  return gtk_editable_get_position (gtk_editable ());
}

bool
Inti::Gtk::Entry::editable () const
{
  return gtk_entry ()->editable;
}

void
Inti::Gtk::Entry::cut_clipboard_proxy (GtkEditable * editable)
{
  Inti::Private::proxy_implementation_0 (editable,
                                         &Entry::cut_clipboard_impl);
}

void
Inti::Gtk::Entry::copy_clipboard_proxy (GtkEditable * editable)
{
  Inti::Private::proxy_implementation_0 (editable,
                                         &Entry::copy_clipboard_impl);
}

void
Inti::Gtk::Entry::paste_clipboard_proxy (GtkEditable * editable)
{
  Inti::Private::proxy_implementation_0 (editable,
                                         &Entry::paste_clipboard_impl);
}

void
Inti::Gtk::Entry::cut_clipboard_impl ()
{
  GtkEntryClass * klass = (GtkEntryClass*) original_class ();

  if (klass->cut_clipboard)
    (* klass->cut_clipboard) (gtk_entry ());
}

void
Inti::Gtk::Entry::copy_clipboard_impl ()
{
  GtkEntryClass * klass = (GtkEntryClass*) original_class ();

  if (klass->copy_clipboard)
    (* klass->copy_clipboard) (gtk_entry ());
}

void
Inti::Gtk::Entry::paste_clipboard_impl ()
{
  GtkEntryClass * klass = (GtkEntryClass*) original_class ();

  if (klass->paste_clipboard)
    (* klass->paste_clipboard) (gtk_entry ());
}

/////////////////

void
Inti::Gtk::Entry::changed_proxy (GtkEditable * editable)
{
  Inti::Private::proxy_implementation_0 (editable,
                                         &Entry::changed_impl,
                                         &Entry::on_changed);
}

void
Inti::Gtk::Entry::insert_text_proxy (GtkEditable * editable,
                                     const char * text,
                                     int length, int * position)
{
  Entry *o = (Entry*)
    gtk_object_get_data_by_id ((GtkObject*)editable, Inti::Private::quark ());

  ustring s (text, length);
  o->insert_text_impl (s, position);
  o->on_insert_text (s, position);
}

void
Inti::Gtk::Entry::delete_text_proxy (GtkEditable * editable,
                                        int start_pos, int end_pos)
{
  Inti::Private::proxy_implementation_2 (editable,
                                         &Entry::delete_text_impl,
                                         &Entry::on_delete_text,
                                         start_pos, end_pos);
}

void
Inti::Gtk::Entry::activate_proxy (GtkEditable * editable)
{
  Inti::Private::proxy_implementation_0 (editable,
                                         &Entry::activate_impl,
                                         &Entry::on_activate);
}

void
Inti::Gtk::Entry::changed_impl ()
{
  GtkEntryClass * klass = (GtkEntryClass*) original_class ();

  if (klass->changed)
    (* klass->changed) (gtk_entry ());
}

void
Inti::Gtk::Entry::insert_text_impl (const ustring & text, int * position)
{
  GtkEntryClass * klass = (GtkEntryClass*) original_class ();

  if (klass->insert_text)
    (* klass->insert_text) (gtk_entry (),
                            text.c_str (),
                            text.str ().size (),
                            position);
}

void
Inti::Gtk::Entry::delete_text_impl (int start_pos, int end_pos)
{
  GtkEntryClass * klass = (GtkEntryClass*) original_class ();

  if (klass->delete_text)
    (* klass->delete_text) (gtk_entry (), start_pos, end_pos);
}

void
Inti::Gtk::Entry::activate_impl ()
{
  GtkEntryClass * klass = (GtkEntryClass*) original_class ();

  if (klass->activate)
    (* klass->activate) (gtk_entry ());
}

////////////


void
Inti::Gtk::Entry::on_changed ()
{
  // nothing
}

void
Inti::Gtk::Entry::on_insert_text (const ustring & text, int * position)
{
  // nothing
}

void
Inti::Gtk::Entry::on_delete_text (int start_pos, int end_pos)
{
  // nothing
}

void
Inti::Gtk::Entry::on_activate ()
{
  // nothing
}

void
Inti::Gtk::Entry::select_region (int start, int end)
{
   gtk_editable_select_region (gtk_editable (), start, end);
}

void
Inti::Gtk::Entry::delete_text (int start_pos, int end_pos)
{
   gtk_editable_delete_text (gtk_editable (), start_pos, end_pos);
}

void
Inti::Gtk::Entry::cut_clipboard ()
{
   gtk_editable_cut_clipboard (gtk_editable ());
}

void
Inti::Gtk::Entry::copy_clipboard ()
{
   gtk_editable_copy_clipboard (gtk_editable ());
}

void
Inti::Gtk::Entry::paste_clipboard ()
{
   gtk_editable_paste_clipboard (gtk_editable ());
}

void
Inti::Gtk::Entry::delete_selection ()
{
   gtk_editable_delete_selection (gtk_editable ());
}

void
Inti::Gtk::Entry::set_position (int position)
{
   gtk_editable_set_position (gtk_editable (), position);
}

void
Inti::Gtk::Entry::set_editable (bool is_editable)
{
   gtk_editable_set_editable (gtk_editable (), is_editable);
}

/////////// Everything below here is machine-generated
void
Inti::Gtk::Entry::set_text (const ustring& text)
{
   gtk_entry_set_text (gtk_entry (), text.c_str ());
}
void
Inti::Gtk::Entry::append_text (const ustring& text)
{
   gtk_entry_append_text (gtk_entry (), text.c_str ());
}
void
Inti::Gtk::Entry::prepend_text (const ustring& text)
{
   gtk_entry_prepend_text (gtk_entry (), text.c_str ());
}
void
Inti::Gtk::Entry::set_max_length (guint16 max)
{
   gtk_entry_set_max_length (gtk_entry (), max);
}
void
Inti::Gtk::Entry::set_visibility (bool visible)
{
   gtk_entry_set_visibility (gtk_entry (), visible);
}
void
Inti::Gtk::Entry::set_invisible_char (gunichar ch)
{
   gtk_entry_set_invisible_char (gtk_entry (), ch);
}
const Inti::Gtk::Entry::ChangedSignalType
Inti::Gtk::Entry::changed_signal ("changed", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Entry::InsertTextSignalType
Inti::Gtk::Entry::insert_text_signal ("insert_text", (Private::SignalFunc)Private::slot2_void_string_length_intp_callback);

const Inti::Gtk::Entry::DeleteTextSignalType
Inti::Gtk::Entry::delete_text_signal ("delete_text", (Private::SignalFunc)Private::slot2_void_int_int_callback);

const Inti::Gtk::Entry::ActivateSignalType
Inti::Gtk::Entry::activate_signal ("activate", (Private::SignalFunc)Private::slot0_void_callback);

