// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_BOX_H_
#define _INTI_GTK_BOX_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/container.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkvbox.h>

/*$ doc header
  $short #Inti::Gtk::VBox arranges child widgets in a column,
  #Inti::Gtk::HBox arranges them in a row
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class BoxClass;
      class HBoxClass;
      class VBoxClass;
    };
    
    class Box : public Container
    {
    public:
      /*$ doc class Box
        $short abstract base class for #HBox and #VBox; a #Box lays
        out a row or column of child widgets.

        $copy none
        $memory floating
        
        $long

        <para>

        </para>

        <para>

        </para>
        
        $*/
        
      GtkBox * gtk_box () const
      {
        return (GtkBox*)g_object ();
      }

      void pack_start (Inti::Gtk::Widget* child, bool expand, bool fill, unsigned int padding);
      void pack_end (Inti::Gtk::Widget* child, bool expand, bool fill, unsigned int padding);
      void set_homogeneous (bool homogeneous);
      void set_spacing (int spacing);
      void reorder_child (Inti::Gtk::Widget* child, int position);
      
      bool homogeneous () const { return gtk_box ()->homogeneous; }
      int spacing () const { return gtk_box ()->spacing; }

      // FIXME I'm declaring set_child_packing and query_child_packing
      // to be useless outside of GUI builders, so no interface for
      // them. I'd rather leave them out than fool with a complicated
      // iterator interface as in gtk--.
      
    protected:
      friend class Private::BoxClass;

      Box ();
      Box (bool homogeneous, int spacing);
      explicit Box (GtkBox *src, GtkBoxClass * orig);
      virtual ~Box () = 0; // abstract base class
      
    private:
      Box(const Box&);
      Box& operator=(const Box&);
      
    }; // class Box

    class HBox : public Box
    {
    public:
      /*$ doc class HBox
        $short a horizontal #Box

        $copy none
        $memory floating
        
        $long

        <para>

        </para>

        <para>

        </para>
        
        $*/
        
      GtkHBox * gtk_hbox () const
      {
        return (GtkHBox*)g_object ();
      }

      HBox ();
      HBox (bool homogeneous, int spacing);
      
    protected:
      friend class Private::HBoxClass;
      
      explicit HBox (GtkHBox *src, GtkHBoxClass * orig);
      virtual ~HBox ();
      
    private:
      HBox(const HBox&);
      HBox& operator=(const HBox&);
      
    }; // class HBox

    class VBox : public Box
    {
    public:
      /*$ doc class VBox
        $short a vertical #Box

        $copy none
        $memory floating
        
        $long

        <para>

        </para>

        <para>

        </para>
        
        $*/
        
      GtkVBox * gtk_vbox () const
      {
        return (GtkVBox*)g_object ();
      }

      VBox ();
      VBox (bool homogeneous, int spacing);
      
    protected:
      friend class Private::VBoxClass;
      
      explicit VBox (GtkVBox *src, GtkVBoxClass * orig);
      virtual ~VBox ();
      
    private:
      VBox(const VBox&);
      VBox& operator=(const VBox&);
      
    }; // class VBox    
    
  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_BOX_H_
