// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_ACCELERATORS_H_
#define _INTI_GTK_ACCELERATORS_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gdk/gdkbase.h>
#include <inti/utf-string.h>

/*$ doc header
  $short FIXME 
  $*/

namespace Inti
{  
  namespace Gtk
  {
    class Accelerator
    {
    public:
      unsigned int key_val () const { return keyval_; }
      Gdk::ModifierTypeField modifiers () const { return modifiers_; }
      void set_key_val (unsigned int val);
      void set_modifiers (Gdk::ModifierTypeField mods);

      // overloading on both int and pointer is sort of evil, but
      // since we never expect 0 as a value here, I guess it's OK
      Accelerator (const ustring & spec);
      Accelerator (const char * spec);
      Accelerator (unsigned int keyval);
      Accelerator (unsigned int keyval, Gdk::ModifierTypeField mod);

      // Default copy and destructor
      
      bool valid () const;
      
      ustring serialize () const;
      void unserialize (const ustring & spec);
      void unserialize (const char * spec);

      static void set_default_modifiers (Gdk::ModifierTypeField modifiers);
      static Gdk::ModifierTypeField default_modifiers ();

    private:
      unsigned int keyval_;
      Gdk::ModifierTypeField modifiers_;
    };
    
    
  }; // namespace Gtk 
}; // namespace Inti

#endif // _INTI_GTK_ACCELERATORS_H_
