// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "visual.h"


Inti::Gdk::Visual::~Visual ()
{

}

int
Inti::Gdk::Visual::best_depth ()
{
  return gdk_visual_get_best_depth ();
}

Inti::Gdk::Visual::Type
Inti::Gdk::Visual::best_type ()
{
  return (Type) gdk_visual_get_best_type ();
}

const Inti::Gdk::Visual *
Inti::Gdk::Visual::system ()
{
  return wrap (gdk_visual_get_system ());
}

const Inti::Gdk::Visual *
Inti::Gdk::Visual::best ()
{
  return wrap (gdk_visual_get_best ());
}

const Inti::Gdk::Visual *
Inti::Gdk::Visual::best_with_depth (int depth)
{
  return wrap (gdk_visual_get_best_with_depth (depth));
}

const Inti::Gdk::Visual *
Inti::Gdk::Visual::best_with_type (Type t)
{
  return wrap (gdk_visual_get_best_with_type ((GdkVisualType)t));
}

const Inti::Gdk::Visual *
Inti::Gdk::Visual::best_with_both (int depth, Type t)
{
  return wrap (gdk_visual_get_best_with_both (depth, (GdkVisualType)t));
}

vector<const Inti::Gdk::Visual*>
Inti::Gdk::Visual::list ()
{
  GList * lst;
  GList * iter;
  vector<const Visual*> visuals;

  lst = gdk_list_visuals ();
  iter = lst;
  while (iter != 0)
    {
      visuals.push_back (wrap ((GdkVisual*)iter->data));
      
      iter = g_list_next (lst);
    }

  return visuals;
}

vector<int>
Inti::Gdk::Visual::list_depths ()
{
  int * array_depths = 0;
  int n_depths = 0;

  gdk_query_depths (&array_depths, &n_depths);

  vector<int> depths;
  int i = 0;
  while (i < n_depths)
    {
      depths.push_back (array_depths[i]);
      ++i;
    }

  return depths;
}

vector<Inti::Gdk::Visual::Type>
Inti::Gdk::Visual::list_types ()
{
  GdkVisualType * array_types = 0;
  int n_types = 0;
  
  gdk_query_visual_types (&array_types, &n_types);
  
  vector<Type> types;
  int i = 0;
  while (i < n_types)
    {
      types.push_back ((Type)array_types[i]);
      ++i;
    }

  return types;
}



/////////// Everything below here is machine-generated
