// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "region.h"

Inti::Gdk::Region::Region ()
{
  region_ = gdk_region_new ();  
}

Inti::Gdk::Region::Region (const vector<Point> & points, FillRule rule)
{
  GdkPoint * gdk_points = g_new (GdkPoint, points.size ());

  unsigned int i = 0;
  while (i < points.size ())
    {
      gdk_points[i] = * points[i].gdk_point ();
      ++i;
    }
  
  region_ = gdk_region_polygon (gdk_points, points.size (),
                                (GdkFillRule) rule);
  g_free (gdk_points);
}

Inti::Gdk::Region::Region (const Rectangle & rectangle)
{
  region_ = gdk_region_rectangle (rectangle.gdk_rectangle ());
}

Inti::Gdk::Region &
Inti::Gdk::Region::operator= (const Region& src)
{
  if (region_ != src.region_)
    {
      if (region_)
        gdk_region_destroy (region_);
      
      region_ = gdk_region_copy (src.region_);
    }

  return *this;
}

Inti::Gdk::Region::Region (const Region & src)
{
  region_ = gdk_region_copy (src.region_);
}

Inti::Gdk::Region::Region (GdkRegion * gdk_region, bool copy)
{
  if (copy)
    region_ = gdk_region_copy (gdk_region);
  else
    region_ = gdk_region;
}

Inti::Gdk::Region::~Region ()
{
  gdk_region_destroy (region_);
}

Inti::Gdk::Rectangle
Inti::Gdk::Region::clipbox () const
{
  GdkRectangle rect;
  gdk_region_get_clipbox (region_, &rect);
  return *Rectangle::wrap (&rect);
}

bool
Inti::Gdk::Region::empty () const
{
  return gdk_region_empty (region_);

}

bool
Inti::Gdk::Region::operator==(const Region & rhs) const
{
  if (&rhs == this)
    return true;

  return gdk_region_equal (region_, rhs.region_);
}

bool
Inti::Gdk::Region::operator!=(const Region & rhs) const
{
  return !(*this == rhs);
}

bool
Inti::Gdk::Region::contains (int x, int y) const
{
  return gdk_region_point_in (region_, x, y);
}

bool
Inti::Gdk::Region::contains (const Point & point) const
{
  return gdk_region_point_in (region_, point.x (), point.y ());
}

Inti::Gdk::OverlapType
Inti::Gdk::Region::overlaps (const Rectangle & rect) const
{
  return (OverlapType)
    gdk_region_rect_in (region_, rect.gdk_rectangle ());
}

void
Inti::Gdk::Region::offset (int x, int y)
{
  gdk_region_offset (region_, x, y);
}

void
Inti::Gdk::Region::union_with (const Region & region)
{
  gdk_region_union (region_, region.region_);
}

void
Inti::Gdk::Region::union_with (const Rectangle & rect)
{
  gdk_region_union_with_rect (region_, rect.gdk_rectangle ());
}

void
Inti::Gdk::Region::intersection_with (const Region & region)
{
  gdk_region_intersect (region_, region.region_);  
}

void
Inti::Gdk::Region::xor_with (const Region & region)
{
  gdk_region_xor (region_, region.region_);
}
      
void
Inti::Gdk::Region::subtract (const Region & region)
{
  gdk_region_subtract (region_, region.region_);
}

GdkRegion *
Inti::Gdk::Region::gdk_region () const
{
  return region_;
}

/////////// Everything below here is machine-generated
