#!/usr/bin/env python
# -*- Mode: Python; py-indent-offset: 4 -*-

import string
import re
import exceptions
import errno
import sys

boiler_template = \
"""// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
// See the file COPYING for licensing details.

#include <inti/gtk/%(parent_header)s.h>
#include <inti/gtk/gtkbase.h>
#include <gtk/%(gtk_header)s.h>

/*$ doc header
  $short FIXME
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class %(name)sClass;
    };
    
    class %(name)s : public %(parent)s
    {
    public:
      /*$ doc class %(name)s
        $short FIXME

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      Gtk%(name)s * gtk_%(uscore_name)s () const
      {
        return (Gtk%(name)s*)gtk_object ();
      }

      /*$ doc constructor
        $short Construct a new %(name)s
        $long

        <para>

        </para>
        
        $*/
      %(name)s ();
      
    protected:
      friend class Private::%(name)sClass;
      
      explicit %(name)s (Gtk%(name)s *src, Gtk%(name)sClass *orig);
      virtual ~%(name)s ();
      
    private:
      %(name)s(const %(name)s&);
      %(name)s& operator=(const %(name)s&);
      
    }; // class %(name)s

  }; // namespace Gtk
  
}; // namespace Inti

//#implementation
#include "%(header)s.h"
#include "%(header)s-class.h"
#include <inti/private-util.h>

Inti::Gtk::%(name)s::%(name)s ()
  : %(parent)s ((Gtk%(parent)s*)Private::%(name)sClass::make_proxy (),
         (Gtk%(parent)sClass*) Private::%(name)sClass::original_class ())
{

}

Inti::Gtk::%(name)s::%(name)s (Gtk%(name)s *obj, Gtk%(name)sClass * orig)
  : %(parent)s ((Gtk%(parent)s*)obj,
         (Gtk%(parent)sClass*)orig)
{
  
}

Inti::Gtk::%(name)s::~%(name)s ()
{

}
"""

class_boiler_template = \
"""// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
// See the file COPYING for licensing details.


/*$ doc header
  $short The #Inti::Gtk::Private::%(name)sClass class, which is private and internal.
  $*/

#include <gtk/%(gtk_header)s.h>

namespace Inti
{
  namespace Gtk
  {
    class Object;
    class Widget;
    class %(name)s;
    
    namespace Private
    {      

      /*! make class concrete Gtk %(name)s gtk_%(uscore_name)s !*/
      
    }; //namespace Private

  }; // namespace Gtk

}; // namespace Inti

//#implementation
#include "%(header)s-class.h"
#include "%(parent_header)s-class.h"
#include "%(header)s.h"
#include <inti/private-util.h>

void
Inti::Gtk::Private::%(name)sClass::class_init (Gtk%(name)sClass *klass)
{
  %(parent)sClass::class_init ((Gtk%(parent)sClass*) klass);

}
"""

def write_files (header, parent_header, name, parent, uscore_name, gtk_header):
    vals = {
        'header' : header,
        'parent_header' : parent_header,
        'name' : name,
        'parent' : parent,
        'uscore_name' : uscore_name,
        'gtk_header' : gtk_header
        }

    genfile = open (header + '.gen', 'w')
    classgenfile = open (header + '-class.gen', 'w')

    genfile.write ( boiler_template % vals )
    classgenfile.write ( class_boiler_template % vals )


#  header = 'alignment'
#  parent_header = 'bin'
#  name = 'Alignment'
#  parent = 'Bin'
#  uscore_name = 'alignment'
#  gtk_header = 'gtkalignment'

(header, parent_header, name, parent, uscore_name, gtk_header) = sys.argv[1:]

write_files (header, parent_header, name, parent, uscore_name, gtk_header)

