// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_TIMEDATE_H_
#define _INTI_BASE_TIMEDATE_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <inti/utf-string.h>

/*$ doc header
  $short Time-related interfaces
  $*/

namespace Inti
{
  class TimeStamp
  {
  public:
    long seconds () const { return seconds_; }
    long microseconds () const { return microseconds_; }

    TimeStamp ()
      : seconds_ (0), microseconds_ (0)
    {
    }
    
    // method should not be documented
    TimeStamp (GTimeVal* val)
      : seconds_(val->tv_sec), microseconds_(val->tv_usec)
    {
    }

    long microseconds_since (const TimeStamp & ts) const;

    bool operator== (const TimeStamp & rhs);
    bool operator!= (const TimeStamp & rhs) { return !operator== (rhs); }
    bool operator< (const TimeStamp & rhs);
    bool operator<= (const TimeStamp & rhs);
    bool operator> (const TimeStamp & rhs);
    bool operator>= (const TimeStamp & rhs);

  private:
    long seconds_;
    long microseconds_;
  };

  TimeStamp current_timestamp ();
  
  class Date
  {
  public:
    typedef enum
    {
      INVALID_WEEKDAY = G_DATE_BAD_WEEKDAY,
      MONDAY = G_DATE_MONDAY,
      TUESDAY = G_DATE_TUESDAY,
      WEDNESDAY = G_DATE_WEDNESDAY,
      THURSDAY = G_DATE_THURSDAY,
      FRIDAY = G_DATE_FRIDAY,
      SATURDAY = G_DATE_SATURDAY,
      SUNDAY = G_DATE_SUNDAY
    } Weekday;

    typedef enum
    {
      INVALID_MONTH = G_DATE_BAD_MONTH,
      JANUARY = G_DATE_JANUARY,
      FEBRUARY = G_DATE_FEBRUARY,
      MARCH = G_DATE_MARCH,
      APRIL = G_DATE_APRIL,
      MAY = G_DATE_MAY,
      JUNE = G_DATE_JUNE,
      JULY = G_DATE_JULY,
      AUGUST = G_DATE_AUGUST,
      SEPTEMBER = G_DATE_SEPTEMBER,
      OCTOBER = G_DATE_OCTOBER,
      NOVEMBER = G_DATE_NOVEMBER,
      DECEMBER = G_DATE_DECEMBER
    } Month;

    static const unsigned int INVALID_JULIAN;
    static const unsigned int INVALID_DAY;
    static const unsigned int INVALID_YEAR;

    static bool valid_day (unsigned int day);
    static bool valid_month (Month m);
    static bool valid_year (unsigned int year);
    static bool valid_weekday (Weekday w);
    static bool valid_julian (unsigned int julian);
    static bool valid_dmy (unsigned int day, Month m, unsigned int year);
    static bool leap_year (unsigned int year);
    static unsigned int days_in_month (Month m, unsigned int year);
    static unsigned int monday_weeks_in_year (unsigned int year);
    static unsigned int sunday_weeks_in_year (unsigned int year);
    
    Date ();
    Date (unsigned int day, Month m, unsigned int year);
    // using default assignment and copy
    
    bool valid () const;
    Weekday weekday () const;
    unsigned int julian () const;
    unsigned int year () const;
    unsigned int day () const;
    Month month () const;
    unsigned int day_of_year () const;
    unsigned int monday_week_of_year () const;
    unsigned int sunday_week_of_year () const;
    bool first_of_month () const;
    bool last_of_month () const;
    
    void parse (const ustring & text);
    void parse (const char * text);
    void set_time (GTime t);
    void set_month (Month m);
    void set_day (unsigned int day);
    void set_year (unsigned int year);
    void set_dmy (unsigned int day, Month m, unsigned int year);
    void set_julian (unsigned int julian);
    
    void add_days (unsigned int n_days);
    void subtract_days (unsigned int n_days);

    void add_months (unsigned int n_months);
    void subtract_months (unsigned int n_months);

    void add_years (unsigned int n_years);
    void subtract_years (unsigned int n_years);

    bool operator==(const Date & rhs) const;
    bool operator!=(const Date & rhs) const;
    bool operator<(const Date & rhs) const;
    bool operator<=(const Date & rhs) const;
    bool operator>(const Date & rhs) const;
    bool operator>=(const Date & rhs) const;

    void to_struct_tm (struct tm * tm);
    ustring strftime (const string & format);
    ustring strftime (const char * format);
    
  private:
    mutable GDate date_;
  };
  
}; // namespace Inti


#endif // _INTI_BASE_TIMEDATE_H_
