// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "font.h"

  
const int
Inti::Pango::WEIGHT_NORMAL = int (PANGO_WEIGHT_NORMAL);
const int
Inti::Pango::WEIGHT_BOLD = int (PANGO_WEIGHT_BOLD);
const int
Inti::Pango::WEIGHT_MINIMUM = 100;
const int
Inti::Pango::WEIGHT_MAXIMUM = 900;

void
Inti::Pango::FontDescription::init ()
{
  desc_.family_name = NULL;
  desc_.style = PANGO_STYLE_NORMAL;
  desc_.variant = PANGO_VARIANT_NORMAL;
  desc_.weight = PANGO_WEIGHT_NORMAL;
  desc_.stretch = PANGO_STRETCH_NORMAL;
}

void
Inti::Pango::FontDescription::init (const PangoFontDescription * src)
{
  desc_ = *src;
  if (src->family_name)
    family_ = src->family_name;
  else
    family_ = "";
  desc_.family_name = NULL;
}

Inti::Pango::FontDescription::FontDescription ()
{
  init ();
}

Inti::Pango::FontDescription::FontDescription (const string & description)
{
  set (description);
}

Inti::Pango::FontDescription::FontDescription (const char * description)
{
  set (description);
}

Inti::Pango::FontDescription::FontDescription (const string & family, Style style, int weight)
{
  set (family, style, weight);
}

Inti::Pango::FontDescription::FontDescription (const char * family, Style style, int weight)
{
  set (family, style, weight);
}

Inti::Pango::FontDescription::FontDescription (const PangoFontDescription * pango_font_desc)
{
  init (pango_font_desc);
}

Inti::Pango::FontDescription::FontDescription (const FontDescription & src)
  : family_ (src.family_), desc_ (src.desc_)
{

}

Inti::Pango::FontDescription::FontDescription &
Inti::Pango::FontDescription::operator=(const FontDescription & src)
{
  if (this == &src)
    return *this;
  
  family_ = src.family_;
  desc_ = src.desc_;

  return *this;
}

bool
Inti::Pango::FontDescription::operator==(const FontDescription & rhs) const
{
  return pango_font_description_compare (pango_font_description (),
                                         rhs.pango_font_description ());
}

void
Inti::Pango::FontDescription::set_family (const string & family)
{
  family_ = family;
}

void
Inti::Pango::FontDescription::set_family (const char * family)
{
  family_ = family;
}

const Inti::ustring &
Inti::Pango::FontDescription::family () const
{
  return family_;
}

void
Inti::Pango::FontDescription::set_style (Style style)
{
  desc_.style = (PangoStyle) style;
}

Inti::Pango::Style
Inti::Pango::FontDescription::style () const
{
  return (Style) desc_.style;
}

void
Inti::Pango::FontDescription::set_variant (Variant variant)
{
  desc_.variant = (PangoVariant) variant;
}

Inti::Pango::Variant
Inti::Pango::FontDescription::variant () const
{
  return (Variant) desc_.variant;
}

void
Inti::Pango::FontDescription::set_weight (int weight)
{
  desc_.weight = PangoWeight (weight);
}

int
Inti::Pango::FontDescription::weight () const
{
  return int (desc_.weight);
}

void
Inti::Pango::FontDescription::set_stretch (Stretch str)
{
  desc_.stretch = (PangoStretch) str;
}

Inti::Pango::Stretch
Inti::Pango::FontDescription::stretch () const
{
  return (Stretch) desc_.stretch;
}

void
Inti::Pango::FontDescription::set_size (int size)
{
  desc_.size = size;
}

int
Inti::Pango::FontDescription::size () const
{
  return desc_.size;
}

void
Inti::Pango::FontDescription::set (const string & description)
{
  set (description.c_str ());
}

void
Inti::Pango::FontDescription::set (const char * description)
{
  PangoFontDescription * orig;

  orig = pango_font_description_from_string (description);

  if (orig)
    {
      init (orig);
      pango_font_description_free (orig);
    }
  else
    {
      init ();
    }
}

void
Inti::Pango::FontDescription::set (const string & family, Style style, int weight)
{
  init ();
  set_family (family);
  set_style (style);
  set_weight (weight);
}

void
Inti::Pango::FontDescription::set (const char * family, Style style, int weight)
{
  init ();
  set_family (family);
  set_style (style);
  set_weight (weight);
}

Inti::ustring
Inti::Pango::FontDescription::to_string () const
{
  gchar * s;

  s = pango_font_description_to_string (pango_font_description ());

  ustring retval (s);

  g_free (s);

  return retval;
}

const PangoFontDescription *
Inti::Pango::FontDescription::pango_font_description () const
{
  const_cast<PangoFontDescription&>(desc_).family_name =
    const_cast<char*>(family_.c_str ());

  return &desc_;
}

void
Inti::Pango::FontDescription::set (const PangoFontDescription * desc)
{
  init (desc);
}

/////////// Everything below here is machine-generated
