// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_RADIOBUTTON_H_
#define _INTI_GTK_RADIOBUTTON_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/checkbutton.h>
#include <gtk/gtkradiobutton.h>

/*$ doc header
  $short The #Inti::Gtk::RadioButton widget
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class RadioButtonClass;
    };
    
    class RadioButton : public CheckButton
    {
    public:
      /*$ doc class RadioButton
        $short widget for labelling a UI element, such as a #Button or a #Frame

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/


      class Group
      {
      private:
        friend class RadioButton;
        explicit Group (GSList *list);
        GSList * list_;
      };
      
      GtkRadioButton * gtk_radio_button () const
      {
        return (GtkRadioButton*)g_object ();
      }
      
      /*$ doc constructor
        $short Construct a new radio button
        $long

        <para>

        </para>
        
        $*/
      RadioButton ();

      
      /*$ doc constructor
        $short Construct a new radio button in @group
        $long

        <para>

        </para>
        
        $*/
      RadioButton (Group group);
      
      /*$ doc constructor
        $short Construct a new #RadioButton containing a #Label with the given @text
        @text text the label should display
        $long

        <para>

        </para>
        
        $*/
      RadioButton (const string & text);
      RadioButton (const char * text);

            
      /*$ doc constructor
        $short Construct a new #RadioButton containing a #Label with the given @text
        in the #Group @group
        @group group of radio buttons
        @text text the label should display        
        $long

        <para>

        </para>
        
        $*/
      RadioButton (Group group, const string & text);
      RadioButton (Group group, const char * text);

      Group group () const;
      void set_group (Group group);
      
    protected:
      friend class Private::RadioButtonClass;
      
      explicit RadioButton (GtkRadioButton *src, GtkRadioButtonClass* orig);
      virtual ~RadioButton ();
      
    private:
      RadioButton(const RadioButton&);
      RadioButton& operator=(const RadioButton&);
      
    }; // class RadioButton

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_RADIOBUTTON_H_
