// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "menuitem.h"
#include "menuitem-class.h"
#include "label.h"
#include "marshal.h"
#include "menu.h"
#include <inti/proxies.h>
#include <inti/private-util.h>

Inti::Gtk::MenuItem::MenuItem ()
  : Item ((GtkItem*)Private::MenuItemClass::make_proxy (),
          (GtkItemClass*) Private::MenuItemClass::original_class ())
{

}

Inti::Gtk::MenuItem::MenuItem (const string & text)
  : Item ((GtkItem*)Private::MenuItemClass::make_proxy (),
          (GtkItemClass*) Private::MenuItemClass::original_class ())
{
  Label * label = new Label (text);
  add (label);
  label->show ();
}

Inti::Gtk::MenuItem::MenuItem (const char * text)
  : Item ((GtkItem*)Private::MenuItemClass::make_proxy (),
          (GtkItemClass*) Private::MenuItemClass::original_class ())
{
  Label * label = new Label (text);
  add (label);
  label->show ();
}

Inti::Gtk::MenuItem::MenuItem (GtkMenuItem *obj, GtkMenuItemClass * orig)
  : Item ((GtkItem*)obj,
          (GtkItemClass*)orig)
{
  
}

Inti::Gtk::MenuItem::~MenuItem ()
{

}

void
Inti::Gtk::MenuItem::activate ()
{
  gtk_widget_activate (gtk_widget ());
}


void
Inti::Gtk::MenuItem::set_submenu (Menu * menu)
{
  gtk_menu_item_set_submenu (gtk_menu_item (), menu->gtk_widget ());

}

Inti::Gtk::Menu *
Inti::Gtk::MenuItem::submenu () const
{
  return dynamic_cast<Menu*>(Object::wrap ((GObject*)gtk_menu_item ()->submenu));
}
      
void
Inti::Gtk::MenuItem::set_right_justified (bool setting)
{
  if (setting == gtk_menu_item ()->right_justify)
    return;
  
  // A bit unkosher, to get consistency 
  gtk_menu_item ()->right_justify = setting;

  queue_resize ();
}

bool
Inti::Gtk::MenuItem::right_justified () const
{
  return gtk_menu_item ()->right_justify != FALSE;
}

Inti::Gtk::SeparatorMenuItem::SeparatorMenuItem ()
{

}

Inti::Gtk::SeparatorMenuItem::~SeparatorMenuItem ()
{


}

void
Inti::Gtk::MenuItem::activate_impl ()
{
  GtkMenuItemClass * klass =
    (GtkMenuItemClass *) original_class ();

  if (klass->activate)
    (* klass->activate) (gtk_menu_item ());
}

void
Inti::Gtk::MenuItem::activate_item_impl ()
{
  GtkMenuItemClass * klass =
    (GtkMenuItemClass *) original_class ();

  if (klass->activate_item)
    (* klass->activate_item) (gtk_menu_item ());
}

void
Inti::Gtk::MenuItem::on_activate ()
{
  // nothing
}

void
Inti::Gtk::MenuItem::on_activate_item ()
{
  // nothing
}

void
Inti::Gtk::MenuItem::activate_proxy (GtkMenuItem * mi)
{
  Inti::Private::proxy_implementation_0 (mi,
                                            &MenuItem::activate_impl,
                                            &MenuItem::on_activate);
}

void
Inti::Gtk::MenuItem::activate_item_proxy (GtkMenuItem * mi)
{
  Inti::Private::proxy_implementation_0 (mi,
                                            &MenuItem::activate_item_impl,
                                            &MenuItem::on_activate_item);
}

/////////// Everything below here is machine-generated
const Inti::Gtk::MenuItem::ActivateSignalType
Inti::Gtk::MenuItem::activate_signal ("activate", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::MenuItem::ActivateItemSignalType
Inti::Gtk::MenuItem::activate_item_signal ("activate_item", (Private::SignalFunc)Private::slot0_void_callback);

