// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "entry.h"
#include "entry-class.h"
#include "marshal.h"
#include <inti/private-util.h>

/////////// Object

Inti::Gtk::Entry::Entry ()
  : Editable ((GtkEditable*)Private::EntryClass::make_proxy(),
              (GtkEditableClass*)Private::EntryClass::original_class())
{
  
}

Inti::Gtk::Entry::Entry (GtkEntry *obj,
                         GtkEntryClass *orig)
  : Editable ((GtkEditable*)obj,
              (GtkEditableClass*)orig)
{
  
}

Inti::Gtk::Entry::~Entry ()
{

}


Inti::ustring
Inti::Gtk::Entry::text () const
{
  // Use deprecated function to avoid gratuitous strdup()/free()
  return ustring (gtk_entry_get_text (gtk_entry ()));
}
      
int
Inti::Gtk::Entry::max_length () const
{
  return gtk_entry ()->text_max_length;
}

void
Inti::Gtk::Entry::set_password_mode (bool setting)
{
  gtk_entry_set_visibility (gtk_entry (), !setting);
}

bool
Inti::Gtk::Entry::password_mode () const
{
  return !gtk_editable ()->visible;
}

/////////// Everything below here is machine-generated
void
Inti::Gtk::Entry::set_text (const std::string& text)
{
   gtk_entry_set_text (gtk_entry (), text.c_str ());
}
void
Inti::Gtk::Entry::append_text (const std::string& text)
{
   gtk_entry_append_text (gtk_entry (), text.c_str ());
}
void
Inti::Gtk::Entry::prepend_text (const std::string& text)
{
   gtk_entry_prepend_text (gtk_entry (), text.c_str ());
}
void
Inti::Gtk::Entry::set_max_length (guint16 max)
{
   gtk_entry_set_max_length (gtk_entry (), max);
}
