// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "editable.h"
#include "editable-class.h"
#include "marshal.h"
#include <inti/proxies.h>
#include <inti/private-util.h>

Inti::Gtk::Editable::Editable ()
  : Widget ((GtkWidget*)Private::EditableClass::make_proxy(),
            (GtkWidgetClass*)Private::EditableClass::original_class())
{

}

Inti::Gtk::Editable::Editable (GtkEditable *obj,
                                  GtkEditableClass *orig)
  : Widget ((GtkWidget*)obj,
            (GtkWidgetClass*)orig)
{

}

Inti::Gtk::Editable::~Editable ()
{

}

void
Inti::Gtk::Editable::insert_text (const string & text, int * position)
{
  gtk_editable_insert_text (gtk_editable (),
                            text.c_str (),
                            text.size (),
                            position);
}

void
Inti::Gtk::Editable::insert_text (const char * text, int * position)
{
  gtk_editable_insert_text (gtk_editable (),
                            text,
                            -1,
                            position);
}

Inti::ustring
Inti::Gtk::Editable::get_chars (int start_pos, int end_pos)
{
  gchar * s = gtk_editable_get_chars (gtk_editable (), start_pos, end_pos);

  ustring retval (s);

  g_free (s);

  return retval;
}

int
Inti::Gtk::Editable::position () const
{
  return gtk_editable_get_position (gtk_editable ());
}

bool
Inti::Gtk::Editable::editable () const
{
  return gtk_editable ()->editable;
}

void
Inti::Gtk::Editable::update_text_proxy (GtkEditable * editable,
                                           int start_pos, int end_pos)
{
  Inti::Private::proxy_implementation_2 (editable, &Editable::update_text_impl, start_pos, end_pos);
}

char *
Inti::Gtk::Editable::get_chars_proxy (GtkEditable * editable,
                                         int start_pos, int end_pos)
{
  Editable *o = (Editable*)
    gtk_object_get_data_by_id ((GtkObject*)editable, Inti::Private::quark ());

  ustring s (o->get_chars_impl (start_pos, end_pos));

  return g_strdup (s.c_str ());
}

void
Inti::Gtk::Editable::set_selection_proxy (GtkEditable * editable,
                                             int start_pos, int end_pos)
{
  Inti::Private::proxy_implementation_2 (editable, &Editable::set_selection_impl, start_pos, end_pos);
}

void
Inti::Gtk::Editable::set_position_proxy (GtkEditable * editable,
                                            int pos)
{
  Inti::Private::proxy_implementation_1 (editable, &Editable::set_position_impl, pos);
}

void
Inti::Gtk::Editable::update_text_impl (int start_pos, int end_pos)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->update_text)
    (* klass->update_text) (gtk_editable (), start_pos, end_pos);
}

string
Inti::Gtk::Editable::get_chars_impl (int start_pos, int end_pos)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->get_chars)
    {
      gchar * s = (* klass->get_chars) (gtk_editable (), start_pos, end_pos);
      string retval (s);
      g_free (s);
      return retval;
    }
  else
    return string ("");
}

void
Inti::Gtk::Editable::set_selection_impl (int start_pos, int end_pos)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->set_selection)
    (* klass->set_selection) (gtk_editable (), start_pos, end_pos);
}

void
Inti::Gtk::Editable::set_position_impl (int pos)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->set_position)
    (* klass->set_position) (gtk_editable (), pos);
}

/////////////////

void
Inti::Gtk::Editable::changed_proxy (GtkEditable * editable)
{
  Inti::Private::proxy_implementation_0 (editable,
                                            &Editable::changed_impl,
                                            &Editable::on_changed);
}

void
Inti::Gtk::Editable::insert_text_proxy (GtkEditable * editable,
                                           const char * text,
                                           int length, int * position)
{
  Editable *o = (Editable*)
    gtk_object_get_data_by_id ((GtkObject*)editable, Inti::Private::quark ());

  string s (text, length);
  o->insert_text_impl (s, position);
  o->on_insert_text (s, position);
}

void
Inti::Gtk::Editable::delete_text_proxy (GtkEditable * editable,
                                           int start_pos, int end_pos)
{
  Inti::Private::proxy_implementation_2 (editable,
                                            &Editable::delete_text_impl,
                                            &Editable::on_delete_text,
                                            start_pos, end_pos);
}

void
Inti::Gtk::Editable::activate_proxy (GtkEditable * editable)
{
  Inti::Private::proxy_implementation_0 (editable,
                                            &Editable::activate_impl,
                                            &Editable::on_activate);
}

void
Inti::Gtk::Editable::set_editable_proxy (GtkEditable * editable, gboolean setting)
{
  Inti::Private::proxy_implementation_1 (editable,
                                            &Editable::set_editable_impl,
                                            &Editable::on_set_editable,
                                            (bool)setting);
}

void
Inti::Gtk::Editable::move_cursor_proxy (GtkEditable * editable, int x, int y)
{
  Inti::Private::proxy_implementation_2 (editable,
                                            &Editable::move_cursor_impl,
                                            &Editable::on_move_cursor,
                                            x, y);
}

void
Inti::Gtk::Editable::move_word_proxy (GtkEditable * editable, int n)
{
  Inti::Private::proxy_implementation_1 (editable,
                                            &Editable::move_word_impl,
                                            &Editable::on_move_word,
                                            n);
}

void
Inti::Gtk::Editable::move_page_proxy (GtkEditable * editable, int x, int y)
{
  Inti::Private::proxy_implementation_2 (editable,
                                            &Editable::move_page_impl,
                                            &Editable::on_move_page,
                                            x, y);
}

void
Inti::Gtk::Editable::move_to_row_proxy (GtkEditable * editable, int row)
{
  Inti::Private::proxy_implementation_1 (editable,
                                            &Editable::move_to_row_impl,
                                            &Editable::on_move_to_row,
                                            row);
}

void
Inti::Gtk::Editable::move_to_column_proxy (GtkEditable * editable, int column)
{
  Inti::Private::proxy_implementation_1 (editable,
                                            &Editable::move_to_column_impl,
                                            &Editable::on_move_to_column,
                                            column);
}

void
Inti::Gtk::Editable::kill_char_proxy (GtkEditable * editable, int direction)
{
  Inti::Private::proxy_implementation_1 (editable,
                                            &Editable::kill_char_impl,
                                            &Editable::on_kill_char,
                                            direction);
}

void
Inti::Gtk::Editable::kill_word_proxy (GtkEditable * editable, int direction)
{
  Inti::Private::proxy_implementation_1 (editable,
                                            &Editable::kill_word_impl,
                                            &Editable::on_kill_word,
                                            direction);
}

void
Inti::Gtk::Editable::kill_line_proxy (GtkEditable * editable, int direction)
{
  Inti::Private::proxy_implementation_1 (editable,
                                            &Editable::kill_line_impl,
                                            &Editable::on_kill_line,
                                            direction);
}

void
Inti::Gtk::Editable::cut_clipboard_proxy (GtkEditable * editable)
{
  Inti::Private::proxy_implementation_0 (editable,
                                            &Editable::cut_clipboard_impl,
                                            &Editable::on_cut_clipboard);
}

void
Inti::Gtk::Editable::copy_clipboard_proxy (GtkEditable * editable)
{
  Inti::Private::proxy_implementation_0 (editable,
                                            &Editable::copy_clipboard_impl,
                                            &Editable::on_copy_clipboard);
}

void
Inti::Gtk::Editable::paste_clipboard_proxy (GtkEditable * editable)
{
  Inti::Private::proxy_implementation_0 (editable,
                                            &Editable::paste_clipboard_impl,
                                            &Editable::on_paste_clipboard);
}

void
Inti::Gtk::Editable::changed_impl ()
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->changed)
    (* klass->changed) (gtk_editable ());
}

void
Inti::Gtk::Editable::insert_text_impl (const string & text, int * position)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->insert_text)
    (* klass->insert_text) (gtk_editable (),
                            text.c_str (),
                            text.size (),
                            position);
}

void
Inti::Gtk::Editable::delete_text_impl (int start_pos, int end_pos)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->delete_text)
    (* klass->delete_text) (gtk_editable (), start_pos, end_pos);
}

void
Inti::Gtk::Editable::activate_impl ()
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->activate)
    (* klass->activate) (gtk_editable ());
}

void
Inti::Gtk::Editable::set_editable_impl (bool setting)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->set_editable)
    (* klass->set_editable) (gtk_editable (), setting);
}

void
Inti::Gtk::Editable::move_cursor_impl (int x, int y)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->move_cursor)
    (* klass->move_cursor) (gtk_editable (), x, y);
}

void
Inti::Gtk::Editable::move_word_impl (int n)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->move_word)
    (* klass->move_word) (gtk_editable (), n);
}

void
Inti::Gtk::Editable::move_page_impl (int x, int y)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->move_page)
    (* klass->move_page) (gtk_editable (), x, y);
}

void
Inti::Gtk::Editable::move_to_row_impl (int row)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->move_to_row)
    (* klass->move_to_row) (gtk_editable (), row);
}

void
Inti::Gtk::Editable::move_to_column_impl (int column)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->move_to_column)
    (* klass->move_to_column) (gtk_editable (), column);
}

void
Inti::Gtk::Editable::kill_char_impl (int direction)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->kill_char)
    (* klass->kill_char) (gtk_editable (), direction);
}

void
Inti::Gtk::Editable::kill_word_impl (int direction)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->kill_word)
    (* klass->kill_word) (gtk_editable (), direction);
}

void
Inti::Gtk::Editable::kill_line_impl (int direction)
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->kill_line)
    (* klass->kill_line) (gtk_editable (), direction);
}

void
Inti::Gtk::Editable::cut_clipboard_impl ()
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->cut_clipboard)
    (* klass->cut_clipboard) (gtk_editable ());
}

void
Inti::Gtk::Editable::copy_clipboard_impl ()
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->copy_clipboard)
    (* klass->copy_clipboard) (gtk_editable ());
}

void
Inti::Gtk::Editable::paste_clipboard_impl ()
{
  GtkEditableClass * klass = (GtkEditableClass*) original_class ();

  if (klass->paste_clipboard)
    (* klass->paste_clipboard) (gtk_editable ());
}


////////////


void
Inti::Gtk::Editable::on_changed ()
{
  // nothing
}

void
Inti::Gtk::Editable::on_insert_text (const string & text, int * position)
{
  // nothing
}

void
Inti::Gtk::Editable::on_delete_text (int start_pos, int end_pos)
{
  // nothing
}

void
Inti::Gtk::Editable::on_activate ()
{
  // nothing
}

void
Inti::Gtk::Editable::on_set_editable (bool setting)
{
  // nothing
}

void
Inti::Gtk::Editable::on_move_cursor (int x, int y)
{
  // nothing
}

void
Inti::Gtk::Editable::on_move_word (int n)
{
  // nothing
}

void
Inti::Gtk::Editable::on_move_page (int x, int y)
{
  // nothing
}

void
Inti::Gtk::Editable::on_move_to_row (int row)
{
  // nothing
}

void
Inti::Gtk::Editable::on_move_to_column (int column)
{
  // nothing
}

void
Inti::Gtk::Editable::on_kill_char (int direction)
{
  // nothing
}

void
Inti::Gtk::Editable::on_kill_word (int direction)
{
  // nothing
}

void
Inti::Gtk::Editable::on_kill_line (int direction)
{
  // nothing
}

void
Inti::Gtk::Editable::on_cut_clipboard ()
{
  // nothing
}

void
Inti::Gtk::Editable::on_copy_clipboard ()
{
  // nothing
}

void
Inti::Gtk::Editable::on_paste_clipboard ()
{
  // nothing
}



/////////// Everything below here is machine-generated
void
Inti::Gtk::Editable::select_region (int start, int end)
{
   gtk_editable_select_region (gtk_editable (), start, end);
}
void
Inti::Gtk::Editable::delete_text (int start_pos, int end_pos)
{
   gtk_editable_delete_text (gtk_editable (), start_pos, end_pos);
}
void
Inti::Gtk::Editable::cut_clipboard ()
{
   gtk_editable_cut_clipboard (gtk_editable ());
}
void
Inti::Gtk::Editable::copy_clipboard ()
{
   gtk_editable_copy_clipboard (gtk_editable ());
}
void
Inti::Gtk::Editable::paste_clipboard ()
{
   gtk_editable_paste_clipboard (gtk_editable ());
}
void
Inti::Gtk::Editable::delete_selection ()
{
   gtk_editable_delete_selection (gtk_editable ());
}
void
Inti::Gtk::Editable::set_position (int position)
{
   gtk_editable_set_position (gtk_editable (), position);
}
void
Inti::Gtk::Editable::set_editable (bool is_editable)
{
   gtk_editable_set_editable (gtk_editable (), is_editable);
}
const Inti::Gtk::Editable::ChangedSignalType
Inti::Gtk::Editable::changed_signal ("changed", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Editable::InsertTextSignalType
Inti::Gtk::Editable::insert_text_signal ("insert_text", (Private::SignalFunc)Private::slot2_void_string_length_intp_callback);

const Inti::Gtk::Editable::DeleteTextSignalType
Inti::Gtk::Editable::delete_text_signal ("delete_text", (Private::SignalFunc)Private::slot2_void_int_int_callback);

const Inti::Gtk::Editable::ActivateSignalType
Inti::Gtk::Editable::activate_signal ("activate", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Editable::SetEditableSignalType
Inti::Gtk::Editable::set_editable_signal ("set_editable", (Private::SignalFunc)Private::slot1_void_bool_callback);

const Inti::Gtk::Editable::MoveCursorSignalType
Inti::Gtk::Editable::move_cursor_signal ("move_cursor", (Private::SignalFunc)Private::slot2_void_int_int_callback);

const Inti::Gtk::Editable::MoveWordSignalType
Inti::Gtk::Editable::move_word_signal ("move_word", (Private::SignalFunc)Private::slot1_void_int_callback);

const Inti::Gtk::Editable::MovePageSignalType
Inti::Gtk::Editable::move_page_signal ("move_page", (Private::SignalFunc)Private::slot2_void_int_int_callback);

const Inti::Gtk::Editable::MoveToRowSignalType
Inti::Gtk::Editable::move_to_row_signal ("move_to_row", (Private::SignalFunc)Private::slot1_void_int_callback);

const Inti::Gtk::Editable::MoveToColumnSignalType
Inti::Gtk::Editable::move_to_column_signal ("move_to_column", (Private::SignalFunc)Private::slot1_void_int_callback);

const Inti::Gtk::Editable::KillCharSignalType
Inti::Gtk::Editable::kill_char_signal ("kill_char", (Private::SignalFunc)Private::slot1_void_int_callback);

const Inti::Gtk::Editable::KillWordSignalType
Inti::Gtk::Editable::kill_word_signal ("kill_word", (Private::SignalFunc)Private::slot1_void_int_callback);

const Inti::Gtk::Editable::KillLineSignalType
Inti::Gtk::Editable::kill_line_signal ("kill_line", (Private::SignalFunc)Private::slot1_void_int_callback);

const Inti::Gtk::Editable::CutClipboardSignalType
Inti::Gtk::Editable::cut_clipboard_signal ("cut_clipboard", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Editable::CopyClipboardSignalType
Inti::Gtk::Editable::copy_clipboard_signal ("copy_clipboard", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Editable::PasteClipboardSignalType
Inti::Gtk::Editable::paste_clipboard_signal ("paste_clipboard", (Private::SignalFunc)Private::slot0_void_callback);

void
Inti::Gtk::Editable::claim_selection (bool claim, guint32 time)
{
   gtk_editable_claim_selection (gtk_editable (), claim, time);
}
