// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GDK_REGION_H_
#define _INTI_GDK_REGION_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gdk/gdkbase.h>
#include <gdk/gdkregion.h>
#include <vector>

/*$ doc header
  $short The #Inti::Gdk::Region class (describes a screen area)
  $*/

namespace Inti
{  
  namespace Gdk
  {
    typedef enum
    {
      EVEN_ODD_RULE = GDK_EVEN_ODD_RULE,
      WINDING_RULE = GDK_WINDING_RULE
    } FillRule;
    typedef enum
    {
      OVERLAP_RECTANGLE_IN = GDK_OVERLAP_RECTANGLE_IN,
      OVERLAP_RECTANGLE_OUT = GDK_OVERLAP_RECTANGLE_OUT,
      OVERLAP_RECTANGLE_PART = GDK_OVERLAP_RECTANGLE_PART
    } OverlapType;
    
    class Region
    {
    public:
      Region ();
      Region (const vector<Point> & points, FillRule rule);
      Region (const Rectangle & rectangle);
      ~Region ();
      Region & operator= (const Region& src);
      Region (const Region & src);
      Region (GdkRegion * gdk_region, bool copy);
      
      Rectangle clipbox () const;
      
      bool empty () const;

      bool operator==(const Region & rhs) const;
      bool operator!=(const Region & rhs) const;

      bool contains (int x, int y) const;
      bool contains (const Point & point) const;

      OverlapType overlaps (const Rectangle & rect) const;

      void offset (int x, int y);

      void union_with (const Region & region);
      void union_with (const Rectangle & rect);
      void intersection_with (const Region & region);
      void xor_with (const Region & region);
      
      void subtract (const Region & region);

      GdkRegion * gdk_region () const;
      
    protected:
      
    private:
      GdkRegion * region_;
    }; // class Region

  }; // namespace Gdk
  
}; // namespace Inti

#endif // _INTI_GDK_REGION_H_
