// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GDK_COLOR_H_
#define _INTI_GDK_COLOR_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gdk/gdkbase.h>
#include <gdk/gdkcolor.h>
#include <string>

namespace Inti
{  
  namespace Gdk
  {
    class Colormap;
    
    class Color : private GdkColor
    {
    private:
      typedef GdkColor Base;

    public:
      GdkColor * gdk_color () const
      {
        return (GdkColor*)this;
      }

      static inline Color * wrap (GdkColor * gdk_color)
      {
        return (Color*)gdk_color;
      }
      
      Color ();
      Color (unsigned short red,
             unsigned short green,
             unsigned short blue);

      explicit Color (const char * color_name);
      explicit Color (const string & color_name);
      
      ~Color ();
      // using default copy, assignment.
      
      unsigned short red () const
      {
        return Base::red;
      }

      unsigned short green () const
      {
        return Base::green;
      }
      
      unsigned short blue () const
      {
        return Base::blue;
      }

      unsigned long pixel () const
      {
        return Base::pixel;
      }
      
      void set (unsigned short red,
                unsigned short green,
                unsigned short blue);

      void set (const char * color_name);
      void set (const string & color_name);
      
      void set_red (unsigned short r) { Base::red = r; }
      void set_green (unsigned short g) { Base::green = g; }
      void set_blue (unsigned short b) { Base::blue = b; }
      void set_pixel (unsigned long p) { Base::pixel = p; }

      bool operator==(const Color & rhs);
      bool operator!=(const Color & rhs);

      unsigned int hash () const;
      
    protected:
      
    private:
      
    }; // class Color

  }; // namespace Gdk
  
}; // namespace Inti

#endif // _INTI_GDK_COLOR_H_
