/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include <stdio.h>
#include "_scm.h"


#ifdef __STDC__
static sizet
free_var (SCM obj)
#else
static sizet
free_var (obj)
     SCM obj;
#endif
{
  return 0;
}


#ifdef __STDC__
static int
prin_var (SCM exp, SCM port, int writing)
#else
static int
prin_var (exp, port, writing)
     SCM exp;
     SCM port;
     int writing;
#endif
{
  scm_puts("#<variable ", port);
  scm_intprint(exp, 16, port);
  {
    SCM val_cell;
    val_cell = CDR(exp);
    if (CAR (val_cell) != SCM_UNDEFINED)
      {
	scm_puts(" name: ", port);
	scm_iprin1 (CAR (val_cell), port, writing);
      }
    scm_puts(" binding: ", port);
    scm_iprin1 (CDR (val_cell), port, writing);
  }
  scm_putc('>', port);
  return 1;
}
int scm_tc16_variable;
static scm_smobfuns variable_smob = {scm_markcdr, free_var, prin_var, 0};


static SCM variable_sym;

static char s_make_variable[];
#ifdef __STDC__
static SCM
make_vcell_variable (SCM vcell)
#else
static SCM
make_vcell_variable (vcell)
     SCM vcell;
#endif
{
  SCM answer;
  NEWCELL(answer);
  DEFER_INTS;
  CAR(answer) = scm_tc16_variable;
  CDR(answer) = vcell;
  ALLOW_INTS;
  return answer;
}

PROC (s_make_variable, "make-variable", 2, 0, 0, scm_make_variable);
#ifdef __STDC__
SCM
scm_make_variable (SCM init, SCM name_hint)
#else
SCM
scm_make_variable (init, name_hint)
     SCM init;
     SCM name_hint;
#endif
{
  SCM val_cell;
  NEWCELL(val_cell);
  DEFER_INTS;
  CAR(val_cell) = name_hint;
  CDR(val_cell) = init;
  ALLOW_INTS;
  return make_vcell_variable (val_cell);
}


PROC (s_make_undefined_variable, "make-undefined-variable", 0, 0, 1, scm_make_undefined_variable);
#ifdef __STDC__
SCM
scm_make_undefined_variable (SCM name_hint)
#else
SCM
scm_make_undefined_variable (name_hint)
     SCM name_hint;
#endif
{
  SCM vcell;

  if (name_hint == SCM_UNDEFINED)
    name_hint = variable_sym;

  NEWCELL (vcell);
  DEFER_INTS;
  CAR (vcell) = name_hint;
  CDR (vcell) = SCM_UNDEFINED;
  ALLOW_INTS;
  return make_vcell_variable (vcell);
}


PROC (s_variable_p, "variable?", 1, 0, 0, scm_variable_p);
#ifdef __STDC__
SCM
scm_variable_p (SCM obj)
#else
SCM
scm_variable_p (obj)
     SCM obj;
#endif
{
  return ( (NIMP(obj) && VARIABLEP (obj))
	  ? BOOL_T
	  : BOOL_F);
}


PROC (s_variable_ref, "variable-ref", 1, 0, 0, scm_variable_ref);
#ifdef __STDC__
SCM
scm_variable_ref (SCM var)
#else
SCM
scm_variable_ref (var)
     SCM var;
#endif
{
  ASSERT (NIMP(var) && VARIABLEP(var), var, ARG1, s_variable_ref);
  return CDR (CDR (var));
}



PROC (s_variable_set_x, "variable-set!", 2, 0, 0, scm_variable_set_x);
#ifdef __STDC__
SCM
scm_variable_set_x (SCM var, SCM val)
#else
SCM
scm_variable_set_x (var, val)
     SCM var;
     SCM val;
#endif
{
  ASSERT (NIMP(var) && VARIABLEP (var), var, ARG1, s_variable_set_x);
  CDR (CDR (var)) = val;
  return UNSPECIFIED;
}


PROC (s_builtin_variable, "builtin-variable", 1, 0, 0, scm_builtin_variable);
#ifdef __STDC__
SCM
scm_builtin_variable (SCM name)
#else
SCM
scm_builtin_variable (name)
     SCM name;
#endif
{
  SCM vcell;
  SCM var_slot;

  ASSERT (NIMP (name) && SYMBOLP (name), name, ARG1, s_builtin_variable);
  vcell = scm_sym2vcell (name, BOOL_F, BOOL_F);
  if (vcell == BOOL_F)
    return BOOL_F;

  scm_intern_symbol (symhash_vars, name);
  var_slot = scm_sym2ovcell (name, symhash_vars);

  if (   IMP (CDR (var_slot))
      || (VARVCELL (var_slot) != vcell))
    CDR (var_slot) = make_vcell_variable (vcell);

  return CDR (var_slot);
}


PROC (s_variable_bound_p, "variable-bound?", 1, 0, 0, scm_variable_bound_p);
#ifdef __STDC__
SCM 
scm_variable_bound_p (SCM var)
#else
SCM 
scm_variable_bound_p (var)
     SCM var;
#endif
{
  ASSERT (NIMP(var) && VARIABLEP (var), var, ARG1, s_variable_bound_p);
  return (UNBNDP (CDR (VARVCELL (var)))
	  ? BOOL_F
	  : BOOL_T);
}



#ifdef __STDC__
void
scm_init_variable (void)
#else
void
scm_init_variable ()
#endif
{
  scm_tc16_variable = scm_newsmob (&variable_smob);
  variable_sym = CAR (scm_sysintern ("anonymous-variable", SCM_UNDEFINED));
#include "variable.x"
}

