/* classes: src_files */

/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#include <stdio.h>
#include "_scm.h"



#define latte_type_format "S.S.SS*S"


#ifdef __STDC__
static SCM *
allocate_object (int size, int type_objp)
#else
static SCM *
allocate_object (size, type_objp)
     int size;
     int type_objp;
#endif
{
  int extra;
  SCM * data;

  extra = type_objp ? (2 + n_struct_header) : 0;
  data = (SCM *)scm_must_malloc (sizeof (SCM) * (extra + size), "struct");
  if (type_objp)
    {
      /* Ensure that the type data starts on an address
       * aligned on a 2-word boundry.
       */
      *data = 0;
      ++data;

      if ((unsigned long)data & 0x7)
	{
	  *data = 1;
	  ++data;
	}
      if ((unsigned long)data & 0x7)
	{
	  /* in case there are weird mallocs in the world */
	  ALLOW_INTS;
	  scm_puts ("\nFATAL ERROR DURING CRITICAL CODE SECTION\n", cur_errp);
	  exit(EXIT_FAILURE);
	}
    }
  return data;
}




static char s_sys_make_struct[];

#ifdef __STDC__
static SCM
_scm_make_struct (SCM type, SCM nelts, int internal, int typeobjp)
#else
static SCM
_scm_make_struct (type, nelts, internal, typeobjp)
     SCM type;
     SCM nelts;
     int internal;
     int typeobjp;
#endif
{
  SCM answer;
  SCM format;
  int len;
  int dyn_len;
  SCM * mem;
  SCM gc_prot_handle;
  int shoudnt_make;

  /* As a special case, construct the 
   * the root type.
   */
  if (type == BOOL_F)
    {
      if (first_type != BOOL_F)
	return first_type;
      else
	{
	  SCM * protomem;
	  NEWCELL (type);
	  protomem = (SCM *)allocate_object (n_struct_header, 1);
	  DEFER_INTS;
	  CDR (type) = (SCM)protomem;
	  CAR (type) = (SCM)protomem + 1;
	  protomem[struct_i_name] = CAR (scm_intern0 ("latte-type"));
	  protomem[struct_i_vcell] = 0;
	  protomem[struct_i_format] = CAR (scm_intern0 (latte_type_format));
	  protomem[struct_i_refcnt] = 0;
	  protomem[struct_i_self] = type;
	  protomem[struct_i_sekrit] = BOOL_F;
	  protomem[struct_i_vtab_size] = 0;
	  ALLOW_INTS;
	  first_type = type;
	  return type;
	}
    }
  
  ASSERT (NIMP (type) && STRUCT_TYPEP (type), type, ARG1, s_sys_make_struct);
  if ((nelts == BOOL_F) || (nelts == SCM_UNDEFINED))
    nelts = MAKINUM (0);
  ASSERT (INUMP (nelts), nelts, ARG2, s_sys_make_struct);

  format = STRUCT_TYPE_FORMAT (type);
  len = LENGTH (format);
  dyn_len = INUM (nelts);

  ASSERT ((dyn_len == 0) || ((len > 1) && ('*' == CHARS (format)[len - 2])),
	  dyn_len, OUTOFRANGE, s_sys_make_struct);

  NEWCELL (answer);
  if (0 ==  STRUCT_TYPE_REFCNT(type))
    {
      NEWCELL (gc_prot_handle);
    }

  DEFER_INTS;
  if (0 ==  STRUCT_TYPE_REFCNT(type)++)
    {
      CAR (gc_prot_handle) = type;
      CDR (gc_prot_handle) = type_obj_list;
      type_obj_list = gc_prot_handle;
    }
  
  CAR (answer) = CDR (type) + 1;
  mem = allocate_object (len + dyn_len, typeobjp);
  CDR (answer) = (SCM)mem;
  {
    char * f;
    int i;
    SCM last_val;
    int f_inc;
    int full_len;

    shoudnt_make = 0;
    f_inc = 1;
    full_len = len + dyn_len;
    for (i = 0, f = CHARS (format); i < full_len; ++i, (f += f_inc))
      {
	switch (*f)
	  {
	  case 'I':
	  case 'F':
	  case 'L':
	  case 'D':
	  case '.':
	    if (!internal)
	      shoudnt_make = 1;
	  case 'i':
	  case 'f':
	  case 'l':
	  case 'd':
	  case '2':
	    mem[i] = last_val = 0;
	    break;

	  case 'S':
	    if (!internal)
	      shoudnt_make = 1;
	  case 's':
	    mem[i] = last_val = EOL;
	    break;

	  case '*':
	    if (i != (len - 2))
	      {
		mem[i] = 0;
		shoudnt_make = 1;
	      }
	    else
	      {
		mem[i] = dyn_len;
		f += 1;
		f_inc = 0;
	      }
	    break;

	  default:
	    shoudnt_make = 1;
	    mem[i] = 0;
	    break;
	  }
      }
  }
  ALLOW_INTS;
  ASSERT (!shoudnt_make, type,
	  "This type can't be instantiated genericly.",
	  s_sys_make_struct);
  return answer;
}


PROC (s_sys_bottom_struct_type, "%bottom-struct-type", 0, 0, 0, scm_sys_bottom_struct_type);
#ifdef __STDC__
SCM 
scm_sys_bottom_struct_type (void)
#else
SCM 
scm_sys_bottom_struct_type ()
#endif
{
  return _scm_make_struct (BOOL_F, 0, 1, 1);
}


PROC (s_sys_make_struct, "%make-struct", 1, 1, 0, scm_sys_make_struct);
#ifdef __STDC__
SCM
scm_sys_make_struct (SCM type, SCM nelts)
#else
SCM
scm_sys_make_struct (type, nelts)
     SCM type;
     SCM nelts;
#endif
{
  return _scm_make_struct (type, nelts, 0, 0); /* fixme: typeobjp */
}


PROC (s_sys_make_struct_type, "%make-struct-type", 4, 0, 0, scm_sys_make_struct_type);
#ifdef __STDC__
SCM
scm_sys_make_struct_type (SCM name, SCM format, SCM sekrit, SCM vtable)
#else
SCM
scm_sys_make_struct_type (name, format, sekrit, vtable)
     SCM name;
     SCM format;
     SCM sekrit;
     SCM vtable;
#endif
{
  SCM root_type;
  SCM answer;
  int vtab_len;

  ASSERT (NIMP (name) && SYMBOLP (name), name, ARG1, s_sys_make_struct_type);
  ASSERT (NIMP (format) && SYMBOLP (format), name, ARG2, s_sys_make_struct_type);

  root_type = scm_sys_bottom_struct_type ();
  vtab_len = scm_ilength (vtable);
  answer = _scm_make_struct (root_type, MAKINUM (vtab_len), 1, 1);
  STRUCT_TYPE_NAME (answer) = name;
  STRUCT_TYPE_VCELL (answer) = 0;
  STRUCT_TYPE_FORMAT (answer) = format;
  STRUCT_TYPE_REFCNT (answer) = 1;
  STRUCT_TYPE_SELF (answer) = answer;
  STRUCT_TYPE_SEKRIT (answer) = sekrit;
  STRUCT_TYPE_VTAB_SIZE (answer) = vtab_len;
  {
    int x;
    for (x = 0; vtable != EOL; ++x, vtable = CDR (vtable))
      STRUCT_TYPE_VTAB (answer)[x] = CAR (vtable);
  }
  return answer;
}


PROC (s_sys_struct_type_name, "%struct-type-name", 1, 0, 0, scm_sys_struct_type_name);
#ifdef __STDC__
SCM
scm_sys_struct_type_name (SCM obj)
#else
SCM
scm_sys_struct_type_name (obj)
     SCM obj;
#endif
{
  ASSERT (NIMP (obj) && STRUCTP (obj), obj, ARG1, s_sys_struct_type_name);
  return STRUCT_TYPE_NAME (obj);
}


PROC (s_sys_struct_type_format, "%struct-type-format", 1, 0, 0, scm_sys_struct_type_format);
#ifdef __STDC__
SCM
scm_sys_struct_type_format (SCM obj)
#else
SCM
scm_sys_struct_type_format (obj)
     SCM obj;
#endif
{
  ASSERT (NIMP (obj) && STRUCTP (obj), obj, ARG1, s_sys_struct_type_format);
  return STRUCT_TYPE_FORMAT (obj);
}




PROC (s_sys_struct_type_secret_p, "%struct-type-secret?", 2, 0, 0, scm_sys_struct_type_secret_p);
#ifdef __STDC__
SCM 
scm_sys_struct_type_secret_p (SCM obj, SCM guess)
#else
SCM 
scm_sys_struct_type_secret_p (obj, guess)
     SCM obj;
     SCM guess;
#endif
{
  ASSERT (NIMP (obj) && STRUCT_TYPEP (obj),
	  obj, ARG1, s_sys_struct_type_secret_p);

  return (STRUCT_TYPE_SEKRIT (obj) == guess
	  ? BOOL_T
	  : BOOL_F);
}



static char s_sys_struct_ref[];
#ifdef __STDC__
SCM
_struct_ref (SCM obj, int i, int anyp)
#else
SCM
_struct_ref (obj, i, anyp)
     SCM obj;
     int i;
     int anyp;
#endif
{
  SCM format;
  char field_type;

  format = STRUCT_TYPE(obj)[struct_i_format];
  if (   (i > 0)
      && (i >= (-1 + LENGTH (format)))
      && (CHARS(format)[-2 + LENGTH(format)] == '*'))
    field_type = CHARS (format)[-1 + LENGTH (format)];
  else
    {
      ASSERT ((0 <= i) && (i < LENGTH (format)),
	      MAKINUM (i), "ARG2 out of range", s_sys_struct_ref);
      field_type = CHARS (format)[i];
    }

  switch (field_type)
    {
    case '2':
    default:
    illegal:
      scm_wta (MAKINUM (i), "illegal field", s_sys_struct_ref);

    case 'S':
      if (!anyp) goto illegal;
    case 's':
      return ((SCM *)CDR (obj))[i];

    case 'I':
      if (!anyp) goto illegal;
    case 'i':
    case '*':
      return scm_long2num (((SCM *)CDR (obj))[i]);
    case 'F':
      if (!anyp) goto illegal;
    case 'f':
      return scm_makdbl ((double)*(float *)&(((SCM *)CDR (obj))[i]), 0.0);
    case 'D':
      if (!anyp) goto illegal;
    case 'd':
      return scm_makdbl (*(double *)&(((SCM *)CDR (obj))[i]), 0.0);
    case 'L':
      if (!anyp) goto illegal;
    case 'l':
      {
	long * addr;
	addr = (long *)&(((SCM *)CDR (obj))[i]);
#ifdef LITTLE_ENDIAN
	return MAKINUM (0);
#else
	return MAKINUM (0);
#endif
      }
    }
}



PROC (s_sys_struct_ref, "%struct-ref", 2, 0, 0, scm_sys_struct_ref);
#ifdef __STDC__
SCM
scm_sys_struct_ref (SCM obj, SCM n)
#else
SCM
scm_sys_struct_ref (obj, n)
     SCM obj;
     SCM n;
#endif
{
  ASSERT (NIMP (obj) && STRUCTP (obj), obj, ARG1, s_sys_struct_ref);
  ASSERT (INUMP (n), n, ARG2, s_sys_struct_ref);

  return _struct_ref (obj, INUM (n), 0);
}

PROC (s_sys_struct_checked_ref, "%struct-checked-ref", 3, 0, 0, scm_sys_struct_checked_ref);
#ifdef __STDC__
SCM
scm_sys_struct_checked_ref (SCM obj, SCM n, SCM secret)
#else
SCM
scm_sys_struct_checked_ref (obj, n, secret)
     SCM obj;
     SCM n;
     SCM secret;
#endif
{
  ASSERT (NIMP (obj) && STRUCTP (obj),
	  obj, ARG1, s_sys_struct_checked_ref);
  ASSERT (INUMP (n), n, ARG2, s_sys_struct_checked_ref);
  ASSERT (SCM_STRUCT_TYPE (obj)[scm_struct_i_sekrit] == secret,
	  obj, ARG1, s_sys_struct_checked_ref);
  return _struct_ref (obj, INUM (n), 1);
}



PROC (s_sys_vtab_ref, "%vtab-ref", 2, 0, 0, scm_sys_vtab_ref);
#ifdef __STDC__
SCM
scm_sys_vtab_ref (SCM obj, SCM n)
#else
SCM
scm_sys_vtab_ref (obj, n)
     SCM obj;
     SCM n;
#endif
{
  ASSERT (NIMP (obj) && STRUCT_TYPEP (obj), obj, ARG1, s_sys_vtab_ref);
  ASSERT (INUMP (n), n, ARG2, s_sys_vtab_ref);
  return _struct_ref (obj, struct_i_vtab + INUM (n), 1);
}


static char s_sys_struct_set_x[];

#ifdef __STDC__
static SCM
_sys_struct_set_x (SCM obj, SCM n, SCM val, SCM anyp)
#else
static SCM
_sys_struct_set_x (obj, n, val, anyp)
     SCM obj;
     SCM n;
     SCM val;
     SCM anyp;
#endif
{
  int i;
  SCM format;
  char field_type;

  i = INUM (n);
  format = STRUCT_TYPE(obj)[struct_i_format];
  if (   (i > 0)
      && (i >= (-1 + LENGTH (format)))
      && (CHARS(format)[-2 + LENGTH (format)] == '*'))
    field_type = CHARS (format)[-1 + LENGTH (format)];
  else
    {
      ASSERT ((0 <= i) && (i < LENGTH (format)),
	      n, "ARG2 out of range", s_sys_struct_ref);
      field_type = CHARS (format)[i];
    }

  switch (field_type)
    {
    case '*':
    case '2':
    default:
    illegal:
      scm_wta (n, "illegal field", s_sys_struct_set_x);

    case 'S':
      if (!anyp) goto illegal;
    case 's':
      ((SCM *)CDR (obj))[i] = val;
      break;

    case 'I':
      if (!anyp) goto illegal;
    case 'i':
      ((SCM *)CDR (obj))[i] = scm_num2long (val, (char *)ARG3, s_sys_struct_set_x);
      break;

    case 'u':
      ((SCM *)CDR (obj))[i] = scm_num2ulong (val, (char *)ARG3, s_sys_struct_set_x);
      break;

    case 'F':
      if (!anyp) goto illegal;
    case 'f':
      *((float *)&(((SCM *)CDR (obj))[i])) = scm_num2dbl (val, s_sys_struct_set_x);
      break;

    case 'D':
      if (!anyp) goto illegal;
    case 'd':
      *((double *)&(((SCM *)CDR (obj))[i])) = scm_num2dbl (val, s_sys_struct_set_x);
      break;

    case 'L':
      if (!anyp) goto illegal;
    case 'l':
      {
	long * addr;
	long lo;
	long hi;
	addr = (long *)&(((SCM *)CDR (obj))[i]);
	ASSERT (BOOL_T == scm_exact_p (val), val, ARG1, s_sys_struct_set_x);
	lo = 0xbabe;
	hi = 0xcafe;
#ifdef LITTLE_ENDIAN
	*addr = lo;
	*(addr + 1) = hi;
#else
	*addr = hi;
	*(addr + 1) = lo;
#endif
	break;
      }
    }
  return UNSPECIFIED;
}


PROC (s_sys_struct_set_x, "%struct-set!", 3, 0, 0, scm_sys_struct_set_x);
#ifdef __STDC__
SCM
scm_sys_struct_set_x (SCM obj, SCM n, SCM val)
#else
SCM
scm_sys_struct_set_x (obj, n, val)
     SCM obj;
     SCM n;
     SCM val;
#endif
{
  ASSERT (NIMP (obj) && STRUCTP (obj), obj, ARG1, s_sys_struct_set_x);
  ASSERT (INUMP (n), n, ARG2, s_sys_struct_set_x);

  return _sys_struct_set_x (obj, n, val, 0);
}


PROC (s_sys_struct_checked_set_x, "%struct-checked-set!", 4, 0, 0, scm_sys_struct_checked_set_x);
#ifdef __STDC__
SCM
scm_sys_struct_checked_set_x (SCM obj, SCM n, SCM val, SCM secret)
#else
SCM
scm_sys_struct_checked_set_x (obj, n, val, secret)
     SCM obj;
     SCM n;
     SCM val;
     SCM secret;
#endif
{
  ASSERT (NIMP (obj) && STRUCTP (obj), obj, ARG1, s_sys_struct_checked_set_x);
  ASSERT (INUMP (n), n, ARG2, s_sys_struct_checked_set_x);
  ASSERT (SCM_STRUCT_TYPE (obj)[scm_struct_i_sekrit] == secret,
	  obj, ARG1, s_sys_struct_checked_ref);

  return _sys_struct_set_x (obj, n, val, 1);
}


PROC (s_sys_struct_p, "%struct?", 1, 0, 0, scm_sys_struct_p);
#ifdef __STDC__
SCM
scm_sys_struct_p(SCM obj)
#else
SCM
scm_sys_struct_p(obj)
     SCM obj;
#endif
{
  return ((NIMP (obj) && STRUCTP (obj))
	  ? BOOL_T
	  : BOOL_F);
}

PROC (s_sys_struct_type_p, "%struct-type?", 1, 0, 0, scm_sys_struct_type_p);
#ifdef __STDC__
SCM
scm_sys_struct_type_p(SCM obj)
#else
SCM
scm_sys_struct_type_p(obj)
     SCM obj;
#endif
{
  return ((NIMP (obj) && STRUCT_TYPEP (obj))
	  ? BOOL_T
	  : BOOL_F);
}

PROC (s_sys_struct_type, "%struct-type", 1, 0, 0, scm_sys_struct_type);
#ifdef __STDC__
SCM
scm_sys_struct_type (SCM obj)
#else
SCM
scm_sys_struct_type (obj)
     SCM obj;
#endif
{
  ASSERT (NIMP (obj) && STRUCTP (obj), obj, ARG1, s_sys_struct_type);
  return STRUCT_TYPE (obj)[struct_i_self];
}




#ifdef __STDC__
void
scm_init_struct (void)
#else
void
scm_init_struct ()
#endif
{
#include "struct.x"
}

