/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include <stdio.h>
#include <signal.h>
#include "_scm.h"



#if (__TURBOC__==1)
#define signal ssignal		/* Needed for TURBOC V1.0 */
#endif



/* SIGRETTYPE is the type that signal handlers return.  See <signal.h>*/

#ifdef RETSIGTYPE
#define SIGRETTYPE RETSIGTYPE
#else
#ifdef STDC_HEADERS
#if (__TURBOC__==1)
#define SIGRETTYPE int
#else
#define SIGRETTYPE void
#endif
#else
#ifdef linux
#define SIGRETTYPE void
#else
#define SIGRETTYPE int
#endif
#endif
#endif

#ifdef vms
#ifdef __GNUC__
#define SIGRETTYPE int
#endif
#endif

#ifdef SIGHUP
#ifdef __STDC__
static SIGRETTYPE 
hup_signal (int sig)
#else
static SIGRETTYPE 
hup_signal (sig)
     int sig;
#endif
{
  signal (SIGHUP, hup_signal);
  scm_wta (SCM_UNDEFINED, (char *) HUP_SIGNAL, "");
}
#endif


#ifdef __STDC__
static SIGRETTYPE 
int_signal (int sig)
#else
static SIGRETTYPE 
int_signal (sig)
     int sig;
#endif
{
  sig = errno;
  signal (SIGINT, int_signal);
  if (scm_ints_disabled)
    scm_sig_deferred = 1;
  else
    scm_han_sig ();
  errno = sig;
}

/* If doesn't have SIGFPE, disable FLOATS for the rest of this file. */

#ifndef SIGFPE
#undef FLOATS
#endif

#ifdef FLOATS
#ifdef __STDC__
static SIGRETTYPE 
fpe_signal (int sig)
#else
static SIGRETTYPE 
fpe_signal (sig)
     int sig;
#endif
{
  signal (SIGFPE, fpe_signal);
  scm_wta (SCM_UNDEFINED, (char *) FPE_SIGNAL, "");
}
#endif


#ifdef SIGBUS
#ifdef __STDC__
static SIGRETTYPE 
bus_signal (int sig)
#else
static SIGRETTYPE 
bus_signal (sig)
     int sig;
#endif
{
  signal (SIGBUS, bus_signal);
  scm_wta (SCM_UNDEFINED, (char *) BUS_SIGNAL, "");
}
#endif


#ifdef SIGSEGV			/* AMIGA lacks! */
#ifdef __STDC__
static SIGRETTYPE 
segv_signal (int sig)
#else
static SIGRETTYPE 
segv_signal (sig)
     int sig;
#endif
{
  signal (SIGSEGV, segv_signal);
  scm_wta (SCM_UNDEFINED, (char *) SEGV_SIGNAL, "");
}
#endif
#ifdef atarist
#undef SIGALRM			/* only available via MiNT libs */
#endif
#ifdef GO32
#undef SIGALRM
#endif
#ifdef __HIGHC__
# undef SIGALRM
#endif
#ifdef SIGALRM
#ifdef __STDC__
static SIGRETTYPE 
alrm_signal (int sig)
#else
static SIGRETTYPE 
alrm_signal (sig)
     int sig;
#endif
{
  sig = errno;
  signal (SIGALRM, alrm_signal);
  if (scm_ints_disabled)
    scm_alrm_deferred = 1;
  else
    scm_han_alrm ();
  errno = sig;
}

PROC (s_alarm, "alarm", 1, 0, 0, scm_alarm);
#ifdef __STDC__
SCM 
scm_alarm (SCM i)
#else
SCM 
scm_alarm (i)
     SCM i;
#endif
{
  unsigned int j;
  ASSERT (INUMP (i) && (INUM (i) >= 0), i, ARG1, s_alarm);
  SYSCALL (j = alarm (INUM (i)));
  return MAKINUM (j);
}


#ifndef AMIGA
PROC (s_pause, "pause", 0, 0, 0, scm_pause);
#ifdef __STDC__
SCM 
scm_pause (void)
#else
SCM 
scm_pause ()
#endif
{
  pause ();
  return UNSPECIFIED;
}
#endif
#endif /* SIGALRM */

#ifndef AMIGA
# ifndef _Windows

PROC (s_sleep, "sleep", 1, 0, 0, scm_sleep);
#ifdef __STDC__
SCM 
scm_sleep (SCM i)
#else
SCM 
scm_sleep (i)
     SCM i;
#endif
{
  unsigned int j;
  ASSERT (INUMP (i) && (INUM (i) >= 0), i, ARG1, s_sleep);
#ifdef __HIGHC__
  SYSCALL(j = 0; sleep(INUM(i)););
#else
  SYSCALL(j = sleep(INUM(i)););
#endif
  return MAKINUM (j);
}
# endif
#endif



#ifndef GO32
/* int raise P((int sig)); */
PROC (s_raise, "raise", 1, 0, 0, scm_raise);
#ifdef __STDC__
SCM
scm_raise(SCM sig)
#else
SCM
scm_raise(sig)
     SCM sig;
#endif
{
  ASSERT(INUMP(sig), sig, ARG1, s_raise);
# ifdef vms
  return MAKINUM(gsignal((int)INUM(sig)));
# else
  return kill (getpid(), (int)INUM(sig)) ? BOOL_F : BOOL_T;
# endif
}
#endif

#ifdef TICKS
unsigned int scm_tick_count = 0, scm_ticken = 0;
SCM *scm_loc_tick_signal;
#ifdef __STDC__
void 
scm_tick_signal (void)
#else
void 
scm_tick_signal ()
#endif
{
  if (scm_ticken && NIMP (*scm_loc_tick_signal))
    {
      scm_ticken = 0;
      scm_apply (*scm_loc_tick_signal, EOL, EOL);
    }
}


PROC (s_ticks, "ticks", 1, 0, 0, scm_ticks);
#ifdef __STDC__
SCM 
scm_ticks (SCM i)
#else
SCM 
scm_ticks (i)
     SCM i;
#endif
{
  SCM j = scm_ticken ? scm_tick_count : 0;
  if (!UNBNDP (i))
    scm_ticken = scm_tick_count = INUM (i);
  return MAKINUM (j);
}
#endif

#ifdef SIGHUP
static SIGRETTYPE (*oldhup) ();
#endif
static SIGRETTYPE (*oldint) ();
#ifdef FLOATS
static SIGRETTYPE (*oldfpe) ();
#endif
#ifdef SIGBUS
static SIGRETTYPE (*oldbus) ();
#endif
#ifdef SIGSEGV			/* AMIGA lacks! */
static SIGRETTYPE (*oldsegv) ();
#endif
#ifdef SIGALRM
static SIGRETTYPE (*oldalrm) ();
#endif
#ifdef SIGPIPE
static SIGRETTYPE (*oldpipe) ();
#endif


#ifdef __STDC__
void 
scm_init_signals (void)
#else
void 
scm_init_signals ()
#endif
{
  oldint = signal (SIGINT, int_signal);
#ifdef SIGHUP
  oldhup = signal (SIGHUP, hup_signal);
#endif
#ifdef FLOATS
  oldfpe = signal (SIGFPE, fpe_signal);
#endif
#ifdef SIGBUS
  oldbus = signal (SIGBUS, bus_signal);
#endif
#ifdef SIGSEGV			/* AMIGA lacks! */
  oldsegv = signal (SIGSEGV, segv_signal);
#endif
#ifdef SIGALRM
  alarm (0);			/* kill any pending ALRM interrupts */
  oldalrm = signal (SIGALRM, alrm_signal);
#endif
#ifdef SIGPIPE
  oldpipe = signal (SIGPIPE, SIG_IGN);
#endif
#ifdef ultrix
  siginterrupt (SIGINT, 1);
  siginterrupt (SIGALRM, 1);
  siginterrupt (SIGHUP, 1);
  siginterrupt (SIGPIPE, 1);
#endif /* ultrix */
}

/* This is used in preparation for a possible fork().  Ignore all
   signals before the fork so that child will catch only if it
   establishes a handler */
#ifdef __STDC__
void 
scm_ignore_signals (void)
#else
void 
scm_ignore_signals ()
#endif
{
#ifdef ultrix
  siginterrupt (SIGINT, 0);
  siginterrupt (SIGALRM, 0);
  siginterrupt (SIGHUP, 0);
  siginterrupt (SIGPIPE, 0);
#endif /* ultrix */
  signal (SIGINT, SIG_IGN);
#ifdef SIGHUP
  signal (SIGHUP, SIG_DFL);
#endif
#ifdef FLOATS
  signal (SIGFPE, SIG_DFL);
#endif
#ifdef SIGBUS
  signal (SIGBUS, SIG_DFL);
#endif
#ifdef SIGSEGV			/* AMIGA lacks! */
  signal (SIGSEGV, SIG_DFL);
#endif
  /* Some documentation claims that ALRMs are cleared accross forks.
     If this is not always true then the value returned by alarm(0)
     will have to be saved and scm_unignore_signals() will have to
     reinstate it. */
  /* This code should be neccessary only if the forked process calls
     alarm() without establishing a handler:
     #ifdef SIGALRM
     oldalrm = signal(SIGALRM, SIG_DFL);
     #endif */
  /* These flushes are per warning in man page on fork(). */
  fflush (stdout);
  fflush (stderr);
}

#ifdef __STDC__
void 
scm_unignore_signals (void)
#else
void 
scm_unignore_signals ()
#endif
{
  signal (SIGINT, int_signal);
#ifdef SIGHUP
  signal (SIGHUP, hup_signal);
#endif
#ifdef FLOATS
  signal (SIGFPE, fpe_signal);
#endif
#ifdef SIGBUS
  signal (SIGBUS, bus_signal);
#endif
#ifdef SIGSEGV			/* AMIGA lacks! */
  signal (SIGSEGV, segv_signal);
#endif
#ifdef SIGALRM
  signal (SIGALRM, alrm_signal);
#endif
#ifdef ultrix
  siginterrupt (SIGINT, 1);
  siginterrupt (SIGALRM, 1);
  siginterrupt (SIGHUP, 1);
  siginterrupt (SIGPIPE, 1);
#endif /* ultrix */
}

#ifdef __STDC__
void 
scm_restore_signals (void)
#else
void 
scm_restore_signals ()
#endif
{
#ifdef ultrix
  siginterrupt (SIGINT, 0);
  siginterrupt (SIGALRM, 0);
  siginterrupt (SIGHUP, 0);
  siginterrupt (SIGPIPE, 0);
#endif /* ultrix */
  signal (SIGINT, oldint);
#ifdef SIGHUP
  signal (SIGHUP, oldhup);
#endif
#ifdef FLOATS
  signal (SIGFPE, oldfpe);
#endif
#ifdef SIGBUS
  signal (SIGBUS, oldbus);
#endif
#ifdef SIGSEGV			/* AMIGA lacks! */
  signal (SIGSEGV, oldsegv);
#endif
#ifdef SIGPIPE
  signal (SIGPIPE, oldpipe);
#endif
#ifdef SIGALRM
  alarm (0);			/* kill any pending ALRM interrupts */
  signal (SIGALRM, oldalrm);
#endif
}


#ifdef __STDC__
void
scm_init_scmsigs (void)
#else
void
scm_init_scmsigs ()
#endif
{
#ifdef TICKS
  scm_loc_tick_signal = &CDR(scm_sysintern("ticks-interrupt", SCM_UNDEFINED));
  scm_make_subr(s_ticks, tc7_subr_1o, scm_ticks);
#endif
#include "scmsigs.x"
}

