/* classes: h_files */

#ifndef PORTSH
#define PORTSH
/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include "__scm.h"



struct scm_port_table 
{
  SCM port;			/* Open port.  */
  int revealed;			/* 0 not revealed, > 1 revealed.
				 * Revealed ports do not get GC'd.
				 */
};

extern struct scm_port_table *scm_port_table;
extern scm_port_table_size; /* Number of ports in scm_port_table.  */




/* PORT FLAGS
 * A set of flags caracterizes a port.
 */
#define SCM_OPN		(1L<<16) /* Is the port open? */
#define SCM_RDNG	(2L<<16) /* Is it a readable port? */
#define SCM_WRTNG	(4L<<16) /* Is it writable? */
#define SCM_BUF0	(8L<<16)
#define SCM_CRDY	(32L<<16) /* Should char-ready? return #t? */

/* A mask used to clear the char-ready port flag. */
#define SCM_CUC		0x001fffffL

#define SCM_PORTP(x) (TYP7(x)==scm_tc7_port)
#define SCM_OPPORTP(x) (((0x7f | SCM_OPN) & SCM_CAR(x))==(scm_tc7_port | SCM_OPN))
#define SCM_OPINPORTP(x) (((0x7f | SCM_OPN | SCM_RDNG) & SCM_CAR(x))==(scm_tc7_port | SCM_OPN | SCM_RDNG))
#define SCM_OPOUTPORTP(x) (((0x7f | SCM_OPN | SCM_WRTNG) & SCM_CAR(x))==(scm_tc7_port | SCM_OPN | SCM_WRTNG))
#define SCM_FPORTP(x) (TYP16S(x)==scm_tc7_port)
#define SCM_OPFPORTP(x) (((0xfeff | SCM_OPN) & SCM_CAR(x))==(scm_tc7_port | SCM_OPN))
#define SCM_OPINFPORTP(x) (((0xfeff | SCM_OPN | SCM_RDNG) & SCM_CAR(x))==(scm_tc7_port | SCM_OPN | SCM_RDNG))
#define SCM_OPOUTFPORTP(x) (((0xfeff | SCM_OPN | SCM_WRTNG) & SCM_CAR(x))==(scm_tc7_port | SCM_OPN | SCM_WRTNG))

#define SCM_INPORTP(x) (((0x7f | SCM_RDNG) & SCM_CAR(x))==(scm_tc7_port | SCM_RDNG))
#define SCM_OUTPORTP(x) (((0x7f | SCM_WRTNG) & SCM_CAR(x))==(scm_tc7_port | SCM_WRTNG))
#define SCM_OPENP(x) (SCM_OPN & SCM_CAR(x))
#define SCM_CLOSEDP(x) (!OPENP(x))
#define SCM_STREAM(x) ((FILE *)(SCM_CDR(x)))
#define SCM_SETSTREAM SCM_SETCDR
#define SCM_CRDYP(port) (SCM_CAR(port) & SCM_CRDY)
#define SCM_CLRDY(port) {SCM_CAR(port) &= SCM_CUC;}
#define SCM_CGETUN(port) ((int)SCM_SRS(SCM_CAR(port), 22))
#define SCM_CUNGET(c, port) {SCM_CAR(port) += ((long)c<<22) + SCM_CRDY;}



extern scm_ptobfuns *scm_ptobs;
extern sizet scm_numptob;
extern int scm_port_table_room;


#ifdef __STDC__
extern void scm_add_to_port_table (SCM port);
extern void scm_remove_from_port_table (SCM port);
extern SCM scm_pt_size (void);
extern SCM scm_pt_member (SCM member);
extern SCM scm_close_all_ports_except (SCM ports);
extern int scm_revealed_count (SCM port);
extern SCM scm_port_revealed (SCM port);
extern SCM scm_set_port_revealed_x (SCM port, SCM rcount);
extern void scm_setfileno (FILE *fs, int fd);
extern void scm_evict_ports (int fd);
extern SCM scm_fdes_to_ports (SCM fd);
extern SCM scm_close_port (SCM port);
extern SCM scm_input_port_p (SCM x);
extern SCM scm_output_port_p (SCM x);
extern void scm_prinport (SCM exp, SCM port, char *type);
extern void scm_ports_prehistory (void);
extern void scm_init_ports (void);

#else /* STDC */
extern void scm_add_to_port_table ();
extern void scm_remove_from_port_table ();
extern SCM scm_pt_size ();
extern SCM scm_pt_member ();
extern SCM scm_close_all_ports_except ();
extern int scm_revealed_count ();
extern SCM scm_port_revealed ();
extern SCM scm_set_port_revealed_x ();
extern void scm_setfileno ();
extern void scm_evict_ports ();
extern SCM scm_fdes_to_ports ();
extern SCM scm_close_port ();
extern SCM scm_input_port_p ();
extern SCM scm_output_port_p ();
extern void scm_prinport ();
extern void scm_ports_prehistory ();
extern void scm_init_ports ();

#endif /* STDC */






#endif  /* PORTSH */
