/* classes: h_files */

#ifndef PAIRSH
#define PAIRSH
/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include "__scm.h"



typedef struct scm_cell
{
  SCM car;
  SCM cdr;
} scm_cell;

/* PTR_LT defines how to compare two CELLPTRs (which may not be in the
 * same scm_array).  CELLPTR is a pointer to a cons cell which may be
 * compared or differenced.  SCMPTR is used for stack bounds.
 */

#if !defined(__TURBOC__) || defined(__TOS__)

typedef scm_cell *SCM_CELLPTR;
typedef SCM  *SCMPTR;

# ifdef nosve
#  define SCM_PTR_MASK 0xffffffffffff
#  define SCM_PTR_LT(x, y) (((int)(x)&SCM_PTR_MASK) < ((int)(y)&SCM_PTR_MASK))
# else
#  define SCM_PTR_LT(x, y) ((x) < (y))
# endif /* def nosve */

#else /* defined(__TURBOC__) && !defined(__TOS__) */

# ifdef PROT386
typedef scm_cell *SCM_CELLPTR;
typedef SCM *SCMPTR;
#  define SCM_PTR_LT(x, y) (((long)(x)) < ((long)(y)))
# else
typedef scm_cell huge *SCM_CELLPTR;
typedef SCM  huge *SCMPTR;
#  define SCM_PTR_LT(x, y) ((x) < (y))
# endif /* def PROT386 */

#endif /*  defined(__TURBOC__) && !defined(__TOS__) */



/* Cons Pairs
 */

#define SCM_NCONSP(x) (1 & (int)SCM_CAR(x))
#define SCM_CONSP(x) (!SCM_NCONSP(x))
#define SCM_ECONSP(x) (SCM_CONSP(x) || (1==SCM_TYP3(x)))
#define SCM_NECONSP(x) (SCM_NCONSP(x) && (1 != SCM_TYP3(x)))

#define SCM_CAR(x) (((scm_cell *)(SCM2PTR(x)))->car)
#define SCM_CDR(x) (((scm_cell *)(SCM2PTR(x)))->cdr)
#define SCM_GCCDR(x) (~1L & SCM_CDR(x))
#define SCM_SETCDR(x, v) SCM_CDR(x) = (SCM)(v)

#define SCM_NEWCELL(_into) \
	{ \
	  if (SCM_IMP(scm_freelist)) \
	     _into = scm_gc_for_newcell();\
	  else \
	    { \
	       _into = scm_freelist; \
	       scm_freelist = SCM_CDR(scm_freelist);\
	       ++scm_cells_allocated; \
	    } \
	}


#ifdef __STDC__
extern SCM scm_cons (SCM x, SCM y);
extern SCM scm_cons2 (SCM w, SCM x, SCM y);
extern SCM scm_listify (SCM elt, ...);
extern SCM scm_acons (SCM w, SCM x, SCM y);
extern SCM scm_pair_p(SCM x);
extern SCM scm_set_car_x(SCM pair, SCM value);
extern SCM scm_set_cdr_x(SCM pair, SCM value);
extern SCM scm_null_p(SCM x);
extern long scm_ilength(SCM sx);
extern SCM scm_list_p(SCM x);
extern SCM scm_list(SCM objs);
extern SCM scm_list_length(SCM x);
extern int scm_obj_length (SCM obj);
extern SCM scm_length(SCM x);
extern SCM scm_append(SCM args);
extern SCM scm_reverse(SCM lst);
extern SCM scm_list_ref(SCM lst, SCM k);
extern SCM scm_memq(SCM x, SCM lst);
extern SCM scm_member(SCM x, SCM lst);
extern SCM scm_assq(SCM x, SCM alist);
extern SCM scm_assoc(SCM x, SCM alist);
extern SCM scm_delq_x (SCM item, SCM lst);
extern SCM scm_last_pair(SCM sx);
extern SCM scm_append_x(SCM args);
extern SCM scm_memv (SCM x, SCM lst);
extern SCM scm_assv(SCM x, SCM alist);
extern SCM scm_list_tail(SCM lst, SCM k);
extern void scm_init_pairs (void);

#else /* STDC */
extern SCM scm_cons ();
extern SCM scm_cons2 ();
extern SCM scm_listify ();
extern SCM scm_acons ();
extern SCM scm_pair_p();
extern SCM scm_set_car_x();
extern SCM scm_set_cdr_x();
extern SCM scm_null_p();
extern long scm_ilength();
extern SCM scm_list_p();
extern SCM scm_list();
extern SCM scm_list_length();
extern int scm_obj_length ();
extern SCM scm_length();
extern SCM scm_append();
extern SCM scm_reverse();
extern SCM scm_list_ref();
extern SCM scm_memq();
extern SCM scm_member();
extern SCM scm_assq();
extern SCM scm_assoc();
extern SCM scm_delq_x ();
extern SCM scm_last_pair();
extern SCM scm_append_x();
extern SCM scm_memv ();
extern SCM scm_assv();
extern SCM scm_list_tail();
extern void scm_init_pairs ();

#endif /* STDC */












#endif  /* PAIRSH */
