/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */

#include <stdio.h>
#include "_scm.h"

PROC1 (s_eq_p, "eq?", tc7_rpsubr, scm_eq_p);
#ifdef __STDC__
SCM
scm_eq_p (SCM x, SCM y)
#else
SCM
scm_eq_p (x, y)
     SCM x;
     SCM y;
#endif
{
  return ((x==y)
	  ? BOOL_T
	  : BOOL_F);
}


PROC1 (s_eqv_p, "eqv?", tc7_rpsubr, scm_eqv_p);
#ifdef __STDC__
SCM
scm_eqv_p (SCM x, SCM y)
#else
SCM
scm_eqv_p (x, y)
     SCM x;
     SCM y;
#endif
{
  if (x==y) return BOOL_T;
  if IMP(x) return BOOL_F;
  if IMP(y) return BOOL_F;
  /* this ensures that types and scm_length are the same. */
  if (CAR(x) != CAR(y)) return BOOL_F;
  if NUMP(x) {
# ifdef BIGDIG
    if BIGP(x) return (0==scm_bigcomp(x, y)) ? BOOL_T : BOOL_F;
# endif
#ifdef FLOATS
    if (REALPART(x) != REALPART(y)) return BOOL_F;
    if (CPLXP(x) && (IMAG(x) != IMAG(y))) return BOOL_F;
#endif
    return BOOL_T;
  }
  return BOOL_F;
}

extern SCM scm_array_equal ();

PROC1 (s_equal_p, "equal?", tc7_rpsubr, scm_equal_p);
#ifdef __STDC__
SCM
scm_equal_p (SCM x, SCM y)
#else
SCM
scm_equal_p (x, y)
     SCM x;
     SCM y;
#endif
{
  CHECK_STACK;
 tailrecurse: POLL;
	if (x==y) return BOOL_T;
	if (IMP(x)) return BOOL_F;
	if (IMP(y)) return BOOL_F;
	if (CONSP(x) && CONSP(y)) {
		if FALSEP(scm_equal_p(CAR(x), CAR(y))) return BOOL_F;
		x = CDR(x);
		y = CDR(y);
		goto tailrecurse;
	}
	/* this ensures that types and scm_length are the same. */
	if (CAR(x) != CAR(y)) return BOOL_F;
	switch (TYP7(x)) {
        default: return BOOL_F;
	case tc7_string: return scm_string_equal_p(x, y);
	case tc7_vector: return scm_vector_equal_p(x, y);
	case tc7_lvector:
	  {
	    SCM hook;
	    hook = scm_get_lvector_hook (x, LV_EQUAL_FN);
	    if (hook == BOOL_F)
	      return scm_vector_equal_p (x, y);
	    else
	      return scm_apply (hook,
				scm_cons (x, scm_cons (y, EOL)),
				EOL);
	  }
	case tc7_smob: {
	        int i = SMOBNUM(x);
	        if (!(i < scm_numsmob)) return BOOL_F;
	        if (scm_smobs[i].equalp)
		  return (scm_smobs[i].equalp)(x, y);
		else
		  return BOOL_F;
	      }
	case tc7_bvect: case tc7_uvect: case tc7_ivect:
	case tc7_fvect:	case tc7_cvect: case tc7_dvect:
	  if (   scm_tc16_array
	      && scm_smobs[0x0ff & (scm_tc16_array >> 8)].equalp)
	    return scm_array_equal(x, y);
	}
	return BOOL_F;
}


#ifdef __STDC__
void
scm_init_eq (void)
#else
void
scm_init_eq ()
#endif
{
#include "eq.x"
}

