/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include <stdio.h>
#include <ctype.h>
#include "_scm.h"




PROC1 (s_char_p, "char?", tc7_rpsubr, scm_char_p);
#ifdef __STDC__
SCM
scm_char_p(SCM x)
#else
SCM
scm_char_p(x)
     SCM x;
#endif
{
  return ICHRP(x) ? BOOL_T : BOOL_F;
}

PROC1 (s_char_eq_p, "char=?", tc7_rpsubr, scm_char_eq_p);
#ifdef __STDC__
SCM
scm_char_eq_p(SCM x, SCM y)
#else
SCM
scm_char_eq_p(x, y)
     SCM x;
     SCM y;
#endif
{
  ASSERT(ICHRP(x), x, ARG1, s_char_eq_p);
  ASSERT(ICHRP(y), y, ARG2, s_char_eq_p);
  return (ICHR(x) == ICHR(y)) ? BOOL_T : BOOL_F;
}


PROC1 (s_char_less_p, "char<?", tc7_rpsubr, scm_char_less_p);
#ifdef __STDC__
SCM
scm_char_less_p(SCM x, SCM y)
#else
SCM
scm_char_less_p(x, y)
     SCM x;
     SCM y;
#endif
{
  ASSERT(ICHRP(x), x, ARG1, s_char_less_p);
  ASSERT(ICHRP(y), y, ARG2, s_char_less_p);
  return (ICHR(x) < ICHR(y)) ? BOOL_T : BOOL_F;
}

PROC1 (s_char_leq_p, "char<=?", tc7_rpsubr, scm_char_leq_p);
#ifdef __STDC__
SCM
scm_char_leq_p(SCM x, SCM y)
#else
SCM
scm_char_leq_p(x, y)
     SCM x;
     SCM y;
#endif
{
  ASSERT(ICHRP(x), x, ARG1, s_char_leq_p);
  ASSERT(ICHRP(y), y, ARG2, s_char_leq_p);
  return (ICHR(x) <= ICHR(y)) ? BOOL_T : BOOL_F;
}

PROC1 (s_char_gr_p, "char>?", tc7_rpsubr, scm_char_gr_p);
#ifdef __STDC__
SCM
scm_char_gr_p(SCM x, SCM y)
#else
SCM
scm_char_gr_p(x, y)
     SCM x;
     SCM y;
#endif
{
  ASSERT(ICHRP(x), x, ARG1, s_char_gr_p);
  ASSERT(ICHRP(y), y, ARG2, s_char_gr_p);
  return (ICHR(x) > ICHR(y)) ? BOOL_T : BOOL_F;
}

PROC1 (s_char_geq_p, "char>=?", tc7_rpsubr, scm_char_geq_p);
#ifdef __STDC__
SCM
scm_char_geq_p(SCM x, SCM y)
#else
SCM
scm_char_geq_p(x, y)
     SCM x;
     SCM y;
#endif
{
  ASSERT(ICHRP(x), x, ARG1, s_char_geq_p);
  ASSERT(ICHRP(y), y, ARG2, s_char_geq_p);
  return (ICHR(x) >= ICHR(y)) ? BOOL_T : BOOL_F;
}

PROC1 (s_char_ci_eq_p, "char-ci=?", tc7_rpsubr, scm_char_ci_eq_p);
#ifdef __STDC__
SCM
scm_char_ci_eq_p(SCM x, SCM y)
#else
SCM
scm_char_ci_eq_p(x, y)
     SCM x;
     SCM y;
#endif
{
  ASSERT(ICHRP(x), x, ARG1, s_char_ci_eq_p);
  ASSERT(ICHRP(y), y, ARG2, s_char_ci_eq_p);
  return (scm_upcase[ICHR(x)]==scm_upcase[ICHR(y)]) ? BOOL_T : BOOL_F;
}

PROC1 (s_char_ci_less_p, "char-ci<?", tc7_rpsubr, scm_char_ci_less_p);
#ifdef __STDC__
SCM
scm_char_ci_less_p(SCM x, SCM y)
#else
SCM
scm_char_ci_less_p(x, y)
     SCM x;
     SCM y;
#endif
{
  ASSERT(ICHRP(x), x, ARG1, s_char_ci_less_p);
  ASSERT(ICHRP(y), y, ARG2, s_char_ci_less_p);
  return (scm_upcase[ICHR(x)] < scm_upcase[ICHR(y)]) ? BOOL_T : BOOL_F;
}

PROC1 (s_char_ci_leq_p, "char-ci<=?", tc7_rpsubr, scm_char_ci_leq_p);
#ifdef __STDC__
SCM
scm_char_ci_leq_p(SCM x, SCM y)
#else
SCM
scm_char_ci_leq_p(x, y)
     SCM x;
     SCM y;
#endif
{
  ASSERT(ICHRP(x), x, ARG1, s_char_ci_leq_p);
  ASSERT(ICHRP(y), y, ARG2, s_char_ci_leq_p);
  return (scm_upcase[ICHR(x)] <= scm_upcase[ICHR(y)]) ? BOOL_T : BOOL_F;
}

PROC1 (s_char_ci_gr_p, "char-ci>?", tc7_rpsubr, scm_char_ci_gr_p);
#ifdef __STDC__
SCM
scm_char_ci_gr_p(SCM x, SCM y)
#else
SCM
scm_char_ci_gr_p(x, y)
     SCM x;
     SCM y;
#endif
{
  ASSERT(ICHRP(x), x, ARG1, s_char_ci_gr_p);
  ASSERT(ICHRP(y), y, ARG2, s_char_ci_gr_p);
  return (scm_upcase[ICHR(x)] > scm_upcase[ICHR(y)]) ? BOOL_T : BOOL_F;
}

PROC1 (s_char_ci_geq_p, "char-ci>=?", tc7_rpsubr, scm_char_ci_geq_p);
#ifdef __STDC__
SCM
scm_char_ci_geq_p(SCM x, SCM y)
#else
SCM
scm_char_ci_geq_p(x, y)
     SCM x;
     SCM y;
#endif
{
  ASSERT(ICHRP(x), x, ARG1, s_char_ci_geq_p);
  ASSERT(ICHRP(y), y, ARG2, s_char_ci_geq_p);
  return (scm_upcase[ICHR(x)] >= scm_upcase[ICHR(y)]) ? BOOL_T : BOOL_F;
}


PROC (s_char_alphabetic_p, "char-alphabetic?", 1, 0, 0, scm_char_alphabetic_p);
#ifdef __STDC__
SCM
scm_char_alphabetic_p(SCM chr)
#else
SCM
scm_char_alphabetic_p(chr)
     SCM chr;
#endif
{
  ASSERT(ICHRP(chr), chr, ARG1, s_char_alphabetic_p);
  return (isascii(ICHR(chr)) && isalpha(ICHR(chr))) ? BOOL_T : BOOL_F;
}

PROC (s_char_numeric_p, "char-numeric?", 1, 0, 0, scm_char_numeric_p);
#ifdef __STDC__
SCM
scm_char_numeric_p(SCM chr)
#else
SCM
scm_char_numeric_p(chr)
     SCM chr;
#endif
{
  ASSERT(ICHRP(chr), chr, ARG1, s_char_numeric_p);
  return (isascii(ICHR(chr)) && isdigit(ICHR(chr))) ? BOOL_T : BOOL_F;
}

PROC (s_char_whitespace_p, "char-whitespace?", 1, 0, 0, scm_char_whitespace_p);
#ifdef __STDC__
SCM
scm_char_whitespace_p(SCM chr)
#else
SCM
scm_char_whitespace_p(chr)
     SCM chr;
#endif
{
  ASSERT(ICHRP(chr), chr, ARG1, s_char_whitespace_p);
  return (isascii(ICHR(chr)) && isspace(ICHR(chr))) ? BOOL_T : BOOL_F;
}



PROC (s_char_upper_case_p, "char-upper-case?", 1, 0, 0, scm_char_upper_case_p);
#ifdef __STDC__
SCM
scm_char_upper_case_p(SCM chr)
#else
SCM
scm_char_upper_case_p(chr)
     SCM chr;
#endif
{
  ASSERT(ICHRP(chr), chr, ARG1, s_char_upper_case_p);
  return (isascii(ICHR(chr)) && isupper(ICHR(chr))) ? BOOL_T : BOOL_F;
}


PROC (s_char_lower_case_p, "char-lower-case?", 1, 0, 0, scm_char_lower_case_p);
#ifdef __STDC__
SCM
scm_char_lower_case_p(SCM chr)
#else
SCM
scm_char_lower_case_p(chr)
     SCM chr;
#endif
{
  ASSERT(ICHRP(chr), chr, ARG1, s_char_lower_case_p);
  return (isascii(ICHR(chr)) && islower(ICHR(chr))) ? BOOL_T : BOOL_F;
}


PROC (s_char_to_integer, "char->integer", 1, 0, 0, scm_char_to_integer);
#ifdef __STDC__
SCM
scm_char_to_integer(SCM chr)
#else
SCM
scm_char_to_integer(chr)
     SCM chr;
#endif
{
  ASSERT(ICHRP(chr), chr, ARG1, s_char_to_integer);
  return MAKINUM(ICHR(chr));
}



PROC (s_integer_to_char, "integer->char", 1, 0, 0, scm_integer_to_char);
#ifdef __STDC__
SCM
scm_integer_to_char(SCM n)
#else
SCM
scm_integer_to_char(n)
     SCM n;
#endif
{
  ASSERT(INUMP(n), n, ARG1, s_integer_to_char);
  ASSERT((n >= INUM0) && (n < MAKINUM(CHAR_CODE_LIMIT)),
	 n, OUTOFRANGE, s_integer_to_char);
  return MAKICHR(INUM(n));
}


PROC (s_char_upcase, "char-upcase", 1, 0, 0, scm_char_upcase);
#ifdef __STDC__
SCM
scm_char_upcase(SCM chr)
#else
SCM
scm_char_upcase(chr)
     SCM chr;
#endif
{
  ASSERT(ICHRP(chr), chr, ARG1, s_char_upcase);
  return MAKICHR(scm_upcase[ICHR(chr)]);
}


PROC (s_char_downcase, "char-downcase", 1, 0, 0, scm_char_downcase);
#ifdef __STDC__
SCM
scm_char_downcase(SCM chr)
#else
SCM
scm_char_downcase(chr)
     SCM chr;
#endif
{
  ASSERT(ICHRP(chr), chr, ARG1, s_char_downcase);
  return MAKICHR(scm_downcase[ICHR(chr)]);
}

#ifdef __STDC__
void
scm_init_chars (void)
#else
void
scm_init_chars ()
#endif
{
#include "chars.x"
}

