/* classes: h_files */

#ifndef __SCMH
#define __SCMH
/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#define CAUTIOUS
#define IO_EXTENSIONS
#define PROMPT "guile> "
#define FLOATS
#define SINGLES
#define MEMOIZE_LOCALS
#define GC_FREE_SEGMENTS
#define TICKS
#define MEMOIZE_LOCALS
#define SICP
#define CCLO
#define BIGNUMS
#define ENGNOT
#define ARRAYS


/* This file is the miscellaneous pile of grody SCM macros and declarations.
 *
 * It contains definitions not of interest to a casual reader
 * of guile.h or scm.h, but that are so central to the implementation
 * that most source files need them.
 *
 * In this file, all exported names begin with "scm_" or "SCM_".
 * In the private include file for library sources, "_scm.h", 
 * short hand names are given for many CPP macros.
 */



#ifdef HAVE_LIMITSH
# include <limits.h>
# ifdef UCHAR_MAX
#  define SCM_CHAR_CODE_LIMIT (UCHAR_MAX+1L)
# else
#  define SCM_CHAR_CODE_LIMIT 256L
# endif /* def UCHAR_MAX */
# define SCM_MOST_POSITIVE_FIXNUM (LONG_MAX>>2)
# ifdef _UNICOS			/* Stupid cray bug */
#  define SCM_MOST_NEGATIVE_FIXNUM ((long)LONG_MIN/4)
# else
#  define SCM_MOST_NEGATIVE_FIXNUM SRS((long)LONG_MIN, 2)
# endif				/* UNICOS */
#else
# define SCM_CHAR_CODE_LIMIT 256L
# define SCM_MOST_POSITIVE_FIXNUM ((long)((unsigned long)~0L>>3))
# if (0 != ~0)
#  define SCM_MOST_NEGATIVE_FIXNUM (-SCM_MOST_POSITIVE_FIXNUM-1)
# else
#  define SCM_MOST_NEGATIVE_FIXNUM (-SCM_MOST_POSITIVE_FIXNUM)
# endif /*  (0 != ~0) */
#endif /* def HAVE_LIMITSH */


#include <scmconfig.h>
#include "tags.h"


/** DEFER_INTS/ALLOW_INTS
 ** 
 **/

#ifdef SCM_NON_PREMPTIVE

# define SCM_DEFER_INTS /**/
# ifdef SCM_TICKS
#  define SCM_POLL \
     { \
       if (0==scm_poll_count--) scm_poll_routine(); \
       if (0==scm_tick_count--) scm_tick_signal(); \
     }
# else
#  define SCM_POLL \
     { \
       if (0==scm_poll_count--) \
         scm_poll_routine(); \
     }
# endif /* def SCM_TICKS */
# define SCM_CHECK_INTS SCM_POLL
# define SCM_ALLOW_INTS SCM_POLL
# define SCM_REDEFER_INTS /**/
# define SCM_REALLOW_INTS SCM_POLL

#else  /* is premptive */


# define SCM_REDEFER_INTS {++scm_ints_disabled;}
# define SCM_REALLOW_INTS \
   {\
      --scm_ints_disabled; \
      if (!scm_ints_disabled) \
        SCM_CHECK_INTS;      \
   }

# ifdef SCM_CAREFUL_INTS
#  define SCM_DEFER_INTS {if (scm_ints_disabled) \
		      fputs("ints already disabled\n", stderr); \
			scm_ints_disabled = 1;}
#  define SCM_ALLOW_INTS {if (!scm_ints_disabled) \
		      fputs("ints already enabled\n", stderr); \
			scm_ints_disabled = 0;SCM_CHECK_INTS}
# else
#  define SCM_DEFER_INTS {scm_ints_disabled = 1;}
#  define SCM_ALLOW_INTS {scm_ints_disabled = 0;SCM_CHECK_INTS}
# endif /* def SCM_CAREFUL_INTS */

# ifdef SCM_TICKS
#  define SCM_CHECK_INTS \
     {\
       if (scm_sig_deferred)\
          scm_han_sig(); \
       if (scm_alrm_deferred) \
          scm_han_alrm();\
       SCM_POLL; \
     }
#  define SCM_POLL {if (0==scm_tick_count--) scm_tick_signal();}
# else
#  define SCM_CHECK_INTS {if (scm_sig_deferred) scm_han_sig();if (scm_alrm_deferred) scm_han_alrm();}
#  define SCM_POLL /**/
# endif /* def SCM_TICKS */

#endif /* def SCM_NON_PREMPTIVE */



/** ASSERT
 ** 
 **/


#ifdef SCM_RECKLESS
#define SCM_ASSERT(_cond, _arg, _pos, _subr)
#define SCM_ASRTGO(_cond, _label)
#else
#define SCM_ASSERT(_cond, _arg, _pos, _subr) \
	if (!(_cond)) \
          scm_wta(_arg, (char *)(_pos), _subr)
#define SCM_ASRTGO(_cond, _label) \
        if (!(_cond)) \
          goto _label
#endif


#define SCM_ARGn 		0
#define SCM_ARG1 		1
#define SCM_ARG2 		2
#define SCM_ARG3 		3
#define SCM_ARG4 		4
#define SCM_ARG5 		5
#define SCM_ARG6 		6
#define SCM_ARG7 		7
#define SCM_ARGERR(X) 		((X) < SCM_WNA \
				 ? (char *)(X) \
				 : "wrong type argument")

/* Following must match entry indexes in scm_errmsgs[].
 * Also, WNA must follow the last ARGn in sequence.
 */
#define SCM_WNA 		8
#define SCM_OVFLOW 		9
#define SCM_OUTOFRANGE 		10
#define SCM_NALLOC 		11
#define SCM_EXIT 		12
#define SCM_HUP_SIGNAL 		13
#define SCM_INT_SIGNAL 		14
#define SCM_FPE_SIGNAL 		15
#define SCM_BUS_SIGNAL 		16
#define SCM_SEGV_SIGNAL 	17
#define SCM_ALRM_SIGNAL 	18

struct errdesc
{
  char *msg;
  char *s_response;
  short parent_err;
};


extern struct errdesc scm_errmsgs[];



/* EXIT_SUCCESS is the default code to return from SCM if no errors
 * were encountered.  EXIT_FAILURE is the default code to return from
 * SCM if errors were encountered.  The return code can be explicitly
 * specified in a SCM program with (scm_quit <n>).
 */

#ifndef SCM_EXIT_SUCCESS
# ifdef vms
#  define SCM_EXIT_SUCCESS 1
# else
#  define SCM_EXIT_SUCCESS 0
# endif /* def vms */
#endif /* ndef SCM_EXIT_SUCCESS */
#ifndef SCM_EXIT_FAILURE
# ifdef vms
#  define SCM_EXIT_FAILURE 2
# else
#  define SCM_EXIT_FAILURE 1
# endif /* def vms */
#endif /* ndef SCM_EXIT_FAILURE */




#ifdef __STDC__

#else /* STDC */

#endif /* STDC */


#endif  /* __SCMH */
