/* Author:  G. Jungman
 * RCS:     $Id: gsl_sf_dawson.h,v 1.1 1998/08/18 22:27:18 jungman Exp $
 */
#ifndef GSL_SF_DAWSON_H_
#define GSL_SF_DAWSON_H_


/* Dawson's integral:
 *
 *   Exp[-x^2] Integral[ Exp[t^2], {t,0,x}]
 *
 * exceptions: GSL_EUNDRFLW;
 */
int     gsl_sf_dawson_impl(double x, double * result);
int     gsl_sf_dawson_e(double x, double * result);
double  gsl_sf_dawson(double x);


#endif  /* !GSL_SF_DAWSON_H_ */
