/* Author:  G. Jungman
 * RCS:     $Id: bsearch.c,v 1.4 1998/11/14 02:27:12 bjg Exp $
 */
#include <config.h>
#include <stdlib.h>

#include "bsearch.h"

size_t
interp_bsearch (const double x_array[], double x,
		size_t index_lo,
		size_t index_hi
)
{
  size_t ilo = index_lo;
  size_t ihi = index_hi;
  while (ihi > ilo + 1)
    {
      size_t i = (ihi + ilo) / 2;
      if (x_array[i] > x)
	ihi = i;
      else
	ilo = i;
    }

  return ilo;
}
