/* $Id: gsl_ran.h,v 1.2 1996/10/24 17:28:52 jt Exp $ */
#ifndef _gsl_ran_cmrg_RANDOM_H_
#define _gsl_ran_cmrg_RANDOM_H_

double gsl_ran_cmrg_uniform(void);
void gsl_ran_cmrg_seed(int);

unsigned long gsl_ran_cmrg_random(void);
double gsl_ran_cmrg_max();

void *gsl_ran_cmrg_getRandomState(void);
void gsl_ran_cmrg_setRandomState(void *);

unsigned long gsl_ran_cmrg_random_wstate(void *);
double gsl_ran_cmrg_uniform_wstate(void *);
void gsl_ran_cmrg_seed_wstate(void *, int);

/* Note: it's kind of ugly to have the gaussian random state defined
 * so explicitly, if we used void *'s we would lose some typechecking
 * ability, but it would look better.  maybe if we just called it
 * gsl_ran_cmrg_gState, it wouldn't be so bad...  */
typedef struct {
    int ng;
    double g;
    void *randomState;
} gsl_ran_cmrg_gaussianRandomState;

void gsl_ran_cmrg_copyGaussState(gsl_ran_cmrg_gaussianRandomState *,
                            gsl_ran_cmrg_gaussianRandomState *);
gsl_ran_cmrg_gaussianRandomState *gsl_ran_cmrg_getGaussState(void);
void gsl_ran_cmrg_setGaussState(gsl_ran_cmrg_gaussianRandomState *);
double gsl_ran_cmrg_gaussian_wstate(gsl_ran_cmrg_gaussianRandomState *);
double gsl_ran_cmrg_gaussian();

#endif /* _gsl_ran_cmrg_RANDOM_H_ */
