#!/bin/sh
# Program to delete problem reports for GNATS.
# Contributed by Kevin Hopkins (K.Hopkins@cs.nott.ac.uk).

MAIL_AGENT=/bin/mail
GNATS_ROOT=xGNATS_ROOTx
LIBDIR=xLIBDIRx
PATH=$PATH:$GNATS_ROOT/gnats-bin
PR_EDIT=$LIBDIR/gnats/pr-edit
INDEX=$GNATS_ROOT/gnats-adm/index
GNATS_USER="gnats"
locked=
closed=
closed_state=
force=

usage="Usage: $0 [-fhV] [--version] [--help] [--force] PR | [-c|--closed]"
version=xVERSIONx

# check to see if there is a $EDITOR; if not, use vi
[ -z "$EDITOR" ] && EDITOR=vi

# parse command line.
# for the non-flag argument, assume it's correct.  if it's a full
# id number, use that; if not, find the full id.
# only continue if $full_id is an actual file.

if [ $# -eq 0 ]; then
  echo $usage ; exit 1
fi
case "$1" in
  -V|-v|--version|--ve*)
    echo "$version"; exit 0
    ;;
  -h|--help*)
    echo "$usage"; exit 0
    ;;
  -c|--closed)
    if [ "$#" -eq "1" ] ; then
      closed=t
    else
      echo "$usage"; exit 0
    fi
    ;;
  -f|--force)
    force=t
    ;;
  -*)
    echo "$usage"; exit 1
    ;;
  *)
    if [ "`echo $1 | grep /`" != "" ]; then
      full_id=$1
    else
      full_id=`grep "/$1:" $INDEX | awk -F: '{print $1}' -`
    fi
    ;;
esac

if [ "$closed" = "t" ]
then	looper=`awk -F: '$4 == "closed" { print $1 }' $INDEX`
else	looper=$full_id
fi

if [ "`echo -n`" = "-n" ]
then	echon () { echo $* \\c ; }
else	echon () { echo -n $* ; }
fi

# start of loop
for full_id in $looper
do



trap 'rm -f /tmp/user$$ $INDEX.$$; exit 0' 0
trap 'if [ "$locked" != "" ]; then \
        $PR_EDIT --unlock $full_id ; \
	locked= ; \
      fi ; \
      rm -f /tmp/user$$ $INDEX.$$; exit 1' 1 2 3 13 15

# check $full_id
pr=$GNATS_ROOT/$full_id    # pr = full path of editee

if [ "$full_id" = "" ]; then
  echo "edit-pr: file not found" ; echo $usage ; exit 1
else
  if [ ! -f $pr -o ! -r $pr ]; then
    echo "edit-pr: cannot read PR $full_id"
    echo $usage ; exit 1
  fi
fi

# find a user name
if [ "$USER" != "" ]; then
  me=$USER
else
  if [ "$LOGNAME" != "" ]; then
    me=$LOGNAME
  else
    echo "edit-pr: no user name found---set LOGNAME." ; exit 1
  fi
fi

if [ -z "$HOSTNAME" ]; then
  if [ -f /bin/hostname ] ; then HOSTNAME=`/bin/hostname`
  elif [ -f /usr/bin/hostname ] ; then HOSTNAME=`/usr/bin/hostname`
  # Solaris et al.
  elif [ -f /usr/ucb/hostname ] ; then HOSTNAME=`/usr/ucb/hostname`
  # Irix
  elif [ -f /usr/bsd/hostname ] ; then HOSTNAME=`/usr/bsd/hostname`
  fi
fi

#if [ -n "$HOSTNAME" ]; then
#  me="$me@$HOSTNAME"
#fi

# now we have a valid $full_id.. use its full path

# lock the pr
$PR_EDIT --lock $me $full_id 2> /tmp/user$$
locked=t

if [ -s /tmp/user$$ ]; then
  if [ "`grep exists /tmp/user$$`" = "" ]; then
    echo "edit-pr: PR $full_id is locked by `sed 's/.*by //g' /tmp/user$$`"
  else
    echo "edit-pr: GNATS is presently locked, try again in a moment"
  fi
  rm -f /tmp/user$$
  exit 1
fi

state=`grep '^>State:' $pr | sed -e 's,^>State: ,,g' -e 's, ,,g'`

case $state in
	[Cc]losed)	closed_state=t ;;
	*)		closed_state="" ;;
esac

if [ "$me" = "$GNATS_USER" -a "$closed_state" = "t" ]
then	if [ 


then	echon "Do you want to delete problem $full_id? [n]"
	read answer junk < /dev/tty
	case $answer in
		[yY]*)	;;
		[qQ]*)	if [ "$locked" != "" ]; then
			        $PR_EDIT --unlock $full_id
				locked=
			fi
			exit 0 ;;
		*)	if [ "$locked" != "" ]; then
			        $PR_EDIT --unlock $full_id
				locked=
			fi
			continue ;;
	esac
else	echo "To delete $full_id must be closed and you must be user $GNATS_USER"
	if [ "$locked" != "" ]; then
	        $PR_EDIT --unlock $full_id
		locked=
	fi
	exit 1
fi

# take the relevant line out of the index - it should only be one
cp $INDEX $INDEX.$$
sed "\,^$full_id,d" $INDEX > $INDEX.$$
index_lines=`wc -l $INDEX | awk '{ print $1} '`
new_index_lines=`wc -l $INDEX.$$ | awk '{ print $1} '`
diff=`expr $index_lines - $new_index_lines`
if [ "$diff" -ne "1" ]
then	echo "There should only be one match for $full_id in the index file, not $diff"
	exit 1
fi

# here's where we actually delete the file.
rm $pr && mv $INDEX.$$ $INDEX
echo "All references to $full_id now deleted"

mail_to="gnats-admin"
if [ -n "$HOSTNAME" -a ! -z "$SHOW_HOST" ]; then
  me="$me@$HOSTNAME"
  tmp=""
  for i in $mail_to
  do
    if [ 'echo $i | grep -s "@"' -eq "0" ]; then
      if [ "$tmp" != "" ]; then
	tmp="$tmp $i@$HOSTNAME"
      else
	tmp="$i@$HOSTNAME"
      fi
    fi
  done
  if [ "$tmp" != "" ]; then
    mail_to=$tmp
  fi
fi
$MAIL_AGENT $mail_to << __EOF__
To: $mail_to
From: $me
Subject: Deleted PR $full_id

__EOF__

# call PR_EDIT on the new file and clean up
$PR_EDIT --unlock $full_id

# end of loop
done

exit 0
